/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.cypher;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.CypherQueryCommand;
import org.structr.core.property.PropertyKey;

public class CypherQuery {
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private boolean includeHiddenAndDeleted = false;
    private CypherQueryCommand cypherQueryCommand = null;
    private boolean descending = false;
    private boolean publicOnly = false;
    private String indexQuery = null;
    private String indexName = null;
    private String sortKey = null;
    private long limit = -1L;
    private long offset = -1L;

    private CypherQuery() {
    }

    private CypherQuery(SecurityContext securityContext, String indexName) {
        this.cypherQueryCommand = StructrApp.getInstance(securityContext).command(CypherQueryCommand.class);
        this.indexName = indexName;
    }

    public static CypherQuery query(SecurityContext securityContext, String indexName) {
        CypherQuery query = new CypherQuery(securityContext, indexName);
        return query;
    }

    public CypherQuery sort(String sortKey) {
        return this.sort(sortKey, false);
    }

    public CypherQuery sort(String sortKey, boolean descending) {
        this.descending = descending;
        this.sortKey = sortKey;
        return this;
    }

    public CypherQuery limit(long limit) {
        this.limit = limit;
        return this;
    }

    public CypherQuery offset(long offset) {
        this.offset = offset;
        return this;
    }

    public CypherQuery includeHiddenAndDeleted(boolean includeHiddenAndDeleted) {
        this.includeHiddenAndDeleted = includeHiddenAndDeleted;
        return this;
    }

    public CypherQuery publicOnly(boolean publicOnly) {
        this.publicOnly = publicOnly;
        return this;
    }

    public CypherQuery search(String indexQuery) {
        this.indexQuery = indexQuery;
        return this;
    }

    public CypherQuery search(PropertyKey key, Object value) {
        this.indexQuery = key.dbName().concat(":").concat(value.toString());
        return this;
    }

    public List<GraphObject> execute() throws FrameworkException {
        return this.cypherQueryCommand.execute(this.toString(), this.getParameters(), this.includeHiddenAndDeleted, this.publicOnly);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("START n=node:");
        buf.append(this.indexName);
        buf.append("(\"");
        buf.append(this.indexQuery.trim());
        buf.append("\") ");
        buf.append("RETURN n");
        if (this.sortKey != null) {
            buf.append(" ORDER BY n.");
            buf.append(this.sortKey);
            if (this.descending) {
                buf.append(" DESC");
            }
        }
        if (this.offset >= 0L) {
            buf.append(" SKIP ").append(this.offset);
        }
        if (this.limit >= 0L) {
            buf.append(" LIMIT ").append(this.limit);
        }
        return buf.toString();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

