/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.cypher;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NativeResult;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Value;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;

public abstract class CypherQueryHandler
implements Value<CypherQueryHandler> {
    private static final Logger logger = LoggerFactory.getLogger((String)CypherQueryHandler.class.getName());
    protected RelationshipFactory relFactory = null;
    protected NodeFactory nodeFactory = null;
    protected SecurityContext securityContext = null;
    protected String query = null;

    public abstract Object handleQueryResults(NativeResult var1) throws FrameworkException;

    public CypherQueryHandler(Object ... query) {
        StringBuilder buffer = new StringBuilder();
        for (Object obj : query) {
            buffer.append(obj);
        }
        this.query = buffer.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.nodeFactory = new NodeFactory(securityContext);
        this.relFactory = new RelationshipFactory(securityContext);
    }

    @Override
    public void set(SecurityContext securityContext, CypherQueryHandler value) throws FrameworkException {
    }

    @Override
    public CypherQueryHandler get(SecurityContext securityContext) {
        return this;
    }

    protected List getAsList(Map<String, Object> row, String columnName) {
        return (List)row.get(columnName);
    }

    protected Set getAsSet(Map<String, Object> row, String columnName) {
        return (Set)row.get(columnName);
    }

    protected Collection getAsCollection(Map<String, Object> row, String columnName) {
        return (Collection)row.get(columnName);
    }

    protected Node getAsNode(Map<String, Object> row, String columnName) {
        return (Node)row.get(columnName);
    }

    protected Relationship getAsRelationship(Map<String, Object> row, String columnName) {
        return (Relationship)row.get(columnName);
    }

    protected NodeInterface getAsAbstractNode(Map<String, Object> row, String columnName) throws FrameworkException {
        return this.nodeFactory.instantiate((Node)row.get(columnName));
    }

    protected RelationshipInterface getAsAbstractRelationship(Map<String, Object> row, String columnName) throws FrameworkException {
        return this.relFactory.instantiate((Relationship)row.get(columnName));
    }

    protected GraphObject getAsGraphObject(Map<String, Object> row, String columnName) {
        Object obj = row.get(columnName);
        try {
            if (obj instanceof Node) {
                return this.nodeFactory.instantiate((Node)obj);
            }
            if (obj instanceof Relationship) {
                return this.relFactory.instantiate((Relationship)obj);
            }
        }
        catch (Throwable ignore) {
            logger.warn("Unable to instantiate node {}", obj);
        }
        return null;
    }
}

