/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.structr.api.Predicate;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.util.Iterables;
import org.structr.common.EntityAndPropertiesContainer;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.entity.OtherNodeTypeFilter;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public abstract class AbstractEndpoint {
    public Relationship getSingle(SecurityContext securityContext, Node dbNode, RelationshipType relationshipType, Direction direction, Class otherNodeType) {
        Iterable<Relationship> rels = this.getMultiple(securityContext, dbNode, relationshipType, direction, otherNodeType, null);
        Iterator<Relationship> iterator = rels.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Iterable<Relationship> getMultiple(SecurityContext securityContext, Node dbNode, RelationshipType relationshipType, Direction direction, Class otherNodeType, Predicate<GraphObject> predicate) {
        return Iterables.filter((Predicate)new OtherNodeTypeFilter(securityContext, dbNode, otherNodeType, predicate), (Iterable)dbNode.getRelationships(direction, relationshipType));
    }

    protected PropertyMap getNotionProperties(SecurityContext securityContext, Class type, String storageKey) {
        Map notionPropertyMap = (Map)securityContext.getAttribute("notionProperties");
        if (notionPropertyMap != null) {
            Set<PropertyKey> keySet = Services.getInstance().getConfigurationProvider().getPropertySet(type, "public");
            PropertyMap notionProperties = (PropertyMap)notionPropertyMap.get(storageKey);
            if (notionProperties != null) {
                Iterator<PropertyKey> it = notionProperties.keySet().iterator();
                while (it.hasNext()) {
                    PropertyKey key = it.next();
                    if (keySet.contains(key)) continue;
                    it.remove();
                }
                return notionProperties;
            }
        }
        return null;
    }

    protected List<Relationship> sort(Iterable<Relationship> rels) {
        LinkedList<Relationship> eagerList = new LinkedList<Relationship>();
        for (Relationship r : rels) {
            eagerList.add(r);
        }
        Collections.sort(eagerList, new Comparator<Relationship>(){

            @Override
            public int compare(Relationship r1, Relationship r2) {
                return Long.valueOf(r1.getId()).compareTo(r2.getId());
            }
        });
        return eagerList;
    }

    protected GraphObject unwrap(GraphObject node) throws FrameworkException {
        return this.unwrap(null, null, node, null);
    }

    protected GraphObject unwrap(SecurityContext securityContext, Class actualType, GraphObject node, PropertyMap properties) throws FrameworkException {
        if (node != null && node instanceof EntityAndPropertiesContainer) {
            EntityAndPropertiesContainer container = (EntityAndPropertiesContainer)node;
            if (securityContext != null && actualType != null && properties != null) {
                properties.putAll(PropertyMap.inputTypeToJavaType(securityContext, actualType, container.getProperties()));
            }
            return container.getEntity();
        }
        return node;
    }
}

