/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.auth.HashHelper;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.entity.relationship.Groups;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public abstract class AbstractUser
extends AbstractNode
implements Principal {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractUser.class.getName());
    private Boolean cachedIsAdminFlag = null;
    public static final Object HIDDEN = "****** HIDDEN ******";

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = true;
        valid &= Principal.super.isValid(errorBuffer);
        return valid &= super.isValid(errorBuffer);
    }

    @Override
    public void addSessionId(String sessionId) {
        try {
            Object[] ids = this.getProperty(Principal.sessionIds);
            if (ids != null) {
                if (!ArrayUtils.contains((Object[])ids, (Object)sessionId)) {
                    this.setProperty(Principal.sessionIds, (String[])ArrayUtils.add((Object[])this.getProperty(Principal.sessionIds), (Object)sessionId));
                }
            } else {
                this.setProperty(Principal.sessionIds, new String[]{sessionId});
            }
        }
        catch (FrameworkException ex) {
            logger.error("Could not add sessionId " + sessionId + " to array of sessionIds", (Throwable)ex);
        }
    }

    @Override
    public void removeSessionId(String sessionId) {
        try {
            String[] ids = this.getProperty(Principal.sessionIds);
            ArrayList<String> newSessionIds = new ArrayList<String>();
            if (ids != null) {
                for (String id : ids) {
                    if (id.equals(sessionId)) continue;
                    newSessionIds.add(id);
                }
            }
            this.setProperties(this.securityContext, new PropertyMap(Principal.sessionIds, newSessionIds.toArray(new String[newSessionIds.size()])));
        }
        catch (FrameworkException ex) {
            logger.error("Could not remove sessionId " + sessionId + " from array of sessionIds", (Throwable)ex);
        }
    }

    @Override
    public boolean isAdmin() {
        if (this.cachedIsAdminFlag == null) {
            this.cachedIsAdminFlag = this.getProperty(Principal.isAdmin);
            if (this.cachedIsAdminFlag == null) {
                this.cachedIsAdminFlag = false;
            }
        }
        return this.cachedIsAdminFlag;
    }

    @Override
    public List<Principal> getParents() {
        LinkedList<Principal> parents = new LinkedList<Principal>();
        for (Groups rel : this.getIncomingRelationships(Groups.class)) {
            if (rel == null || rel.getSourceNode() == null) continue;
            parents.add((Principal)rel.getSourceNode());
        }
        return parents;
    }

    @Override
    public boolean isValidPassword(String password) {
        String encryptedPasswordToCheck;
        String encryptedPasswordFromDatabase = this.getEncryptedPassword();
        return encryptedPasswordFromDatabase != null && encryptedPasswordFromDatabase.equals(encryptedPasswordToCheck = HashHelper.getHash(password, this.getSalt()));
    }

    @Override
    public String getEncryptedPassword() {
        boolean dbNodeHasProperty = this.dbNode.hasProperty(password.dbName());
        if (dbNodeHasProperty) {
            Object dbValue = this.dbNode.getProperty(password.dbName());
            return (String)dbValue;
        }
        return null;
    }

    @Override
    public String getSalt() {
        boolean dbNodeHasProperty = this.dbNode.hasProperty(salt.dbName());
        if (dbNodeHasProperty) {
            Object dbValue = this.dbNode.getProperty(salt.dbName());
            return (String)dbValue;
        }
        return null;
    }

    @Override
    public <T> T getProperty(PropertyKey<T> key, Predicate<GraphObject> predicate) {
        if (password.equals(key) || salt.equals(key)) {
            return (T)HIDDEN;
        }
        return super.getProperty(key, predicate);
    }

    @Override
    public Set<String> getAllowedPermissions() {
        return null;
    }

    @Override
    public Set<String> getDeniedPermissions() {
        return null;
    }
}

