/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.api.Predicate;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.CreationContainer;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.FunctionProperty;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;

public interface Favoritable
extends NodeInterface {
    public static final Property<String> favoriteContentType = new FavoriteContentTypeProperty("favoriteContentType");
    public static final Property<String> favoriteContent = new FavoriteContentProperty("favoriteContent");
    public static final Property<String> favoriteContext = new FavoriteContextProperty("favoriteContext");
    public static final Property<String> relIdProperty = new FunctionProperty("relationshipId").readFunction("this._path.id");
    public static final Property<Boolean> isFavoritable = new ConstantBooleanProperty("isFavoritable", true);
    public static final View favView = new View(Favoritable.class, "fav", id, name, type, favoriteContext, favoriteContent, favoriteContentType, relIdProperty);

    public String getContext();

    public String getFavoriteContent();

    public String getFavoriteContentType();

    public void setFavoriteContent(String var1) throws FrameworkException;

    public static Favoritable getFavoritable(GraphObject obj) {
        GraphObject wrapped;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Favoritable) {
            return (Favoritable)obj;
        }
        if (obj instanceof CreationContainer && (wrapped = ((CreationContainer)obj).getWrappedObject()) instanceof Favoritable) {
            return (Favoritable)wrapped;
        }
        return null;
    }

    public static class FavoriteContextProperty
    extends StringProperty {
        public FavoriteContextProperty(String name) {
            super(name);
        }

        @Override
        public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
            Favoritable favoritable = Favoritable.getFavoritable(obj);
            if (favoritable != null) {
                return favoritable.getContext();
            }
            throw new IllegalStateException("Cannot use Favoritable.getContext() on type " + obj.getClass().getName());
        }

        @Override
        public Object setProperty(SecurityContext securityContext, GraphObject obj, String value) throws FrameworkException {
            throw new FrameworkException(422, "Cannot set context via Favoritable interface.");
        }
    }

    public static class FavoriteContentTypeProperty
    extends StringProperty {
        public FavoriteContentTypeProperty(String name) {
            super(name);
        }

        @Override
        public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
            Favoritable favoritable = Favoritable.getFavoritable(obj);
            if (favoritable != null) {
                return favoritable.getFavoriteContentType();
            }
            throw new IllegalStateException("Cannot use Favoritable.getFavoriteContentType() on type " + obj.getClass().getName());
        }

        @Override
        public Object setProperty(SecurityContext securityContext, GraphObject obj, String value) throws FrameworkException {
            throw new FrameworkException(422, "Cannot set content type via Favoritable interface.");
        }
    }

    public static class FavoriteContentProperty
    extends StringProperty {
        public FavoriteContentProperty(String name) {
            super(name);
        }

        @Override
        public String getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
            Favoritable favoritable = Favoritable.getFavoritable(obj);
            if (favoritable != null) {
                return favoritable.getFavoriteContent();
            }
            throw new IllegalStateException("Cannot use Favoritable.getFavoriteContent() on type " + obj.getClass().getName());
        }

        @Override
        public Object setProperty(SecurityContext securityContext, GraphObject obj, String value) throws FrameworkException {
            Favoritable favoritable = Favoritable.getFavoritable(obj);
            if (favoritable == null) {
                throw new IllegalStateException("Cannot use Favoritable.setFavoriteContent() on type " + obj.getClass().getName());
            }
            favoritable.setFavoriteContent(value);
            return null;
        }
    }
}

