/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.LinkedList;
import java.util.List;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.entity.relationship.Groups;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.schema.SchemaService;

public class Group
extends AbstractUser
implements Principal {
    public static final Property<List<Principal>> members = new EndNodes("members", Groups.class);
    public static final Property<Boolean> isGroup = new ConstantBooleanProperty("isGroup", true);
    public static final View uiView = new View(Group.class, "ui", type, name, members, blocked, isGroup);
    public static final View publicView = new View(Group.class, "public", type, name, members, blocked, isGroup);

    public void addMember(Principal user) throws FrameworkException {
        List<Principal> _users = this.getProperty(members);
        _users.add(user);
        this.setProperty(members, _users);
    }

    public void removeMember(Principal user) throws FrameworkException {
        List<Principal> _users = this.getProperty(members);
        _users.remove(user);
        this.setProperty(members, _users);
    }

    @Override
    public List<Principal> getParents() {
        LinkedList<Principal> principals = new LinkedList<Principal>();
        for (Groups groups : this.getIncomingRelationships(Groups.class)) {
            principals.add((Principal)groups.getSourceNode());
        }
        return principals;
    }

    static {
        SchemaService.registerBuiltinTypeOverride("Group", Group.class.getName());
    }
}

