/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.api.graph.Node;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Relation;
import org.structr.core.entity.ValidatedNode;
import org.structr.core.entity.relationship.AbstractListSiblings;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;

public abstract class LinkedListNode<R extends AbstractListSiblings<T, T>, T extends LinkedListNode>
extends ValidatedNode {
    public static final PropertyKey<String> keyProperty = new StringProperty("key");

    public abstract Class<R> getSiblingLinkType();

    public T listGetPrevious(T currentElement) {
        AbstractListSiblings prevRel = (AbstractListSiblings)((AbstractNode)currentElement).getIncomingRelationship(this.getSiblingLinkType());
        if (prevRel != null) {
            return (T)((LinkedListNode)prevRel.getSourceNode());
        }
        return null;
    }

    public T listGetNext(T currentElement) {
        AbstractListSiblings nextRel = (AbstractListSiblings)((AbstractNode)currentElement).getOutgoingRelationship(this.getSiblingLinkType());
        if (nextRel != null) {
            return (T)((LinkedListNode)nextRel.getTargetNode());
        }
        return null;
    }

    public void listInsertBefore(T currentElement, T newElement) throws FrameworkException {
        if (((AbstractNode)currentElement).getId() == ((AbstractNode)newElement).getId()) {
            throw new IllegalStateException("Cannot link a node to itself!");
        }
        T previousElement = this.listGetPrevious(currentElement);
        if (previousElement == null) {
            this.linkNodes(this.getSiblingLinkType(), newElement, currentElement);
        } else {
            this.unlinkNodes(this.getSiblingLinkType(), previousElement, currentElement);
            if (((AbstractNode)previousElement).getId() != ((AbstractNode)newElement).getId()) {
                this.linkNodes(this.getSiblingLinkType(), previousElement, newElement);
            }
            if (((AbstractNode)newElement).getId() != ((AbstractNode)currentElement).getId()) {
                this.linkNodes(this.getSiblingLinkType(), newElement, currentElement);
            }
        }
    }

    public void listInsertAfter(T currentElement, T newElement) throws FrameworkException {
        if (((AbstractNode)currentElement).getId() == ((AbstractNode)newElement).getId()) {
            throw new IllegalStateException("Cannot link a node to itself!");
        }
        T next = this.listGetNext(currentElement);
        if (next == null) {
            this.linkNodes(this.getSiblingLinkType(), currentElement, newElement);
        } else {
            this.unlinkNodes(this.getSiblingLinkType(), currentElement, next);
            this.linkNodes(this.getSiblingLinkType(), currentElement, newElement);
            if (((AbstractNode)newElement).getId() != ((AbstractNode)next).getId()) {
                this.linkNodes(this.getSiblingLinkType(), newElement, next);
            }
        }
    }

    public void listRemove(T currentElement) throws FrameworkException {
        T previousElement = this.listGetPrevious(currentElement);
        T nextElement = this.listGetNext(currentElement);
        if (currentElement != null) {
            if (previousElement != null) {
                this.unlinkNodes(this.getSiblingLinkType(), previousElement, currentElement);
            }
            if (nextElement != null) {
                this.unlinkNodes(this.getSiblingLinkType(), currentElement, nextElement);
            }
        }
        if (previousElement != null && nextElement != null) {
            Node previousNode = ((AbstractNode)previousElement).getNode();
            Node nextNode = ((AbstractNode)nextElement).getNode();
            if (previousNode != null && nextNode != null) {
                this.linkNodes(this.getSiblingLinkType(), previousElement, nextElement);
            }
        }
    }

    public <R extends Relation<T, T, ?, ?>> void linkNodes(Class<R> linkType, T startNode, T endNode) throws FrameworkException {
        this.linkNodes(linkType, startNode, endNode, null);
    }

    public <R extends Relation<T, T, ?, ?>> void linkNodes(Class<R> linkType, T startNode, T endNode, PropertyMap properties) throws FrameworkException {
        StructrApp.getInstance(this.securityContext).create(startNode, endNode, linkType, properties);
    }

    private void unlinkNodes(Class<R> linkType, T startNode, T endNode) throws FrameworkException {
        App app = StructrApp.getInstance(this.securityContext);
        for (RelationshipInterface rel : ((AbstractNode)startNode).getRelationships(linkType)) {
            if (rel == null || !rel.getTargetNode().equals(endNode)) continue;
            app.delete(rel);
        }
    }
}

