/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractEndpoint;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Source;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyMap;

public class ManyStartpoint<S extends NodeInterface>
extends AbstractEndpoint
implements Source<Iterable<Relationship>, Iterable<S>> {
    private static final Logger logger = LoggerFactory.getLogger((String)ManyStartpoint.class.getName());
    private Relation<S, ?, ManyStartpoint<S>, ?> relation = null;

    public ManyStartpoint(Relation<S, ?, ManyStartpoint<S>, ?> relation) {
        this.relation = relation;
    }

    @Override
    public Iterable<S> get(SecurityContext securityContext, NodeInterface node, Predicate<GraphObject> predicate) {
        final NodeFactory nodeFactory = new NodeFactory(securityContext);
        Object rels = this.getRawSource(securityContext, node.getNode(), (Predicate)predicate);
        if (rels != null) {
            return Iterables.map((Function)new Function<Relationship, S>(){

                @Override
                public S apply(Relationship from) throws RuntimeException {
                    return nodeFactory.instantiate(from.getStartNode(), from);
                }
            }, this.sort((Iterable<Relationship>)rels));
        }
        return null;
    }

    @Override
    public Object set(SecurityContext securityContext, NodeInterface targetNode, Iterable<S> collection) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        LinkedList createdRelationship = new LinkedList();
        PropertyMap properties = new PropertyMap();
        NodeInterface actualTargetNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), targetNode, properties);
        LinkedHashSet toBeDeleted = new LinkedHashSet(Iterables.toList((Iterable)this.get(securityContext, actualTargetNode, (Predicate)null)));
        LinkedHashSet toBeCreated = new LinkedHashSet();
        if (collection != null) {
            Iterables.addAll(toBeCreated, collection);
        }
        HashSet intersection = new HashSet(toBeCreated);
        intersection.retainAll(toBeDeleted);
        toBeCreated.removeAll(intersection);
        toBeDeleted.removeAll(intersection);
        if (actualTargetNode != null) {
            for (NodeInterface sourceNode : toBeDeleted) {
                for (AbstractRelationship rel : actualTargetNode.getIncomingRelationships()) {
                    String relTypeName = rel.getRelType().name();
                    String desiredRelType = this.relation.name();
                    if (sourceNode.equals(actualTargetNode)) {
                        logger.warn("Preventing deletion of self relationship {}-[{}]->{}. If you experience issue with this, please report to team@structr.com.", new Object[]{sourceNode, rel.getRelType(), actualTargetNode});
                        continue;
                    }
                    if (!relTypeName.equals(desiredRelType) || !rel.getSourceNode().equals(sourceNode)) continue;
                    app.delete(rel);
                }
            }
            for (NodeInterface sourceNode : toBeCreated) {
                if (sourceNode == null) continue;
                properties.clear();
                NodeInterface actualSourceNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), sourceNode, properties);
                PropertyMap notionProperties = this.getNotionProperties(securityContext, this.relation.getClass(), actualSourceNode.getName() + this.relation.name() + actualTargetNode.getName());
                if (notionProperties != null) {
                    properties.putAll(notionProperties);
                }
                this.relation.ensureCardinality(securityContext, actualSourceNode, actualTargetNode);
                createdRelationship.add(app.create(actualSourceNode, actualTargetNode, this.relation.getClass(), properties));
            }
        }
        return createdRelationship;
    }

    @Override
    public Iterable<Relationship> getRawSource(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getMultiple(securityContext, dbNode, this.relation, Direction.INCOMING, this.relation.getSourceType(), predicate);
    }

    public Relationship getRawTarget(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getSingle(securityContext, dbNode, this.relation, Direction.OUTGOING, this.relation.getTargetType());
    }

    @Override
    public boolean hasElements(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getRawSource(securityContext, dbNode, (Predicate)predicate).iterator().hasNext();
    }
}

