/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.api.graph.Direction;
import org.structr.common.SecurityContext;
import org.structr.common.error.DuplicateRelationshipToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.ManyEndpoint;
import org.structr.core.entity.ManyStartpoint;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.notion.Notion;
import org.structr.core.notion.RelationshipNotion;

public abstract class ManyToMany<S extends NodeInterface, T extends NodeInterface>
extends AbstractRelationship<S, T>
implements Relation<S, T, ManyStartpoint<S>, ManyEndpoint<T>> {
    @Override
    public Relation.Multiplicity getSourceMultiplicity() {
        return Relation.Multiplicity.Many;
    }

    @Override
    public Relation.Multiplicity getTargetMultiplicity() {
        return Relation.Multiplicity.Many;
    }

    @Override
    public ManyStartpoint<S> getSource() {
        return new ManyStartpoint(this);
    }

    @Override
    public ManyEndpoint<T> getTarget() {
        return new ManyEndpoint(this);
    }

    @Override
    public int getCascadingDeleteFlag() {
        return 0;
    }

    @Override
    public int getAutocreationFlag() {
        return 0;
    }

    @Override
    public void ensureCardinality(SecurityContext securityContext, NodeInterface sourceNode, NodeInterface targetNode) throws FrameworkException {
        Class<?> clazz = this.getClass();
        if (sourceNode != null) {
            Iterable<?> outgoingRels = sourceNode.getOutgoingRelationships(clazz);
            for (RelationshipInterface rel : outgoingRels) {
                if (!rel.getTargetNode().equals(targetNode)) continue;
                throw new FrameworkException(422, "Relationship already exists", new DuplicateRelationshipToken(this.getClass().getSimpleName(), "Relationship already exists"));
            }
        }
    }

    @Override
    public Notion getEndNodeNotion() {
        return new RelationshipNotion(this.getTargetIdProperty());
    }

    @Override
    public Notion getStartNodeNotion() {
        return new RelationshipNotion(this.getSourceIdProperty());
    }

    @Override
    public Direction getDirectionForType(Class<? extends NodeInterface> type) {
        return super.getDirectionForType(this.getSourceType(), this.getTargetType(), type);
    }

    @Override
    public Class getOtherType(Class type) {
        switch (this.getDirectionForType(type)) {
            case INCOMING: {
                return this.getSourceType();
            }
            case OUTGOING: {
                return this.getTargetType();
            }
            case BOTH: {
                return this.getSourceType();
            }
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return false;
    }
}

