/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.List;
import java.util.Set;
import org.structr.common.AccessControllable;
import org.structr.common.ValidationHelper;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.SemanticErrorToken;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.ArrayProperty;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.LowercaseStringProperty;
import org.structr.core.property.PasswordProperty;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;

public interface Principal
extends NodeInterface,
AccessControllable {
    public static final String SUPERUSER_ID = "00000000000000000000000000000000";
    public static final String ANONYMOUS = "anonymous";
    public static final String ANYONE = "anyone";
    public static final Property<String[]> sessionIds = new ArrayProperty<String>("sessionIds", String.class).indexedWhenEmpty();
    public static final Property<List<NodeInterface>> ownedNodes = new EndNodes("ownedNodes", PrincipalOwnsNode.class);
    public static final Property<Boolean> blocked = new BooleanProperty("blocked");
    public static final Property<String> eMail = new LowercaseStringProperty("eMail").cmis().indexed();
    public static final Property<String> password = new PasswordProperty("password");
    public static final Property<String> salt = new StringProperty("salt");
    public static final Property<Boolean> isAdmin = new BooleanProperty("isAdmin").indexed().readOnly();
    public static final Property<String> locale = new StringProperty("locale");
    public static final Property<String> publicKey = new StringProperty("publicKey");
    public static final Property<String[]> publicKeys = new ArrayProperty<String>("publicKeys", String.class);
    public static final Property<String> proxyUrl = new StringProperty("proxyUrl");
    public static final Property<String> proxyUsername = new StringProperty("proxyUsername");
    public static final Property<String> proxyPassword = new StringProperty("proxyPassword");

    public List<Principal> getParents();

    public boolean isValidPassword(String var1);

    public String getEncryptedPassword();

    public String getSalt();

    public void addSessionId(String var1);

    public void removeSessionId(String var1);

    public boolean isAdmin();

    public Set<String> getAllowedPermissions();

    public Set<String> getDeniedPermissions();

    @Override
    default public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = true;
        valid &= ValidationHelper.isValidStringNotBlank(this, name, errorBuffer);
        valid &= ValidationHelper.isValidUniqueProperty(this, eMail, errorBuffer);
        String _eMail = this.getProperty(eMail);
        if (_eMail != null && !_eMail.contains("@")) {
            valid = false;
            errorBuffer.add(new SemanticErrorToken(this.getClass().getSimpleName(), eMail, "must_contain_at_character", (Object)_eMail));
        }
        return valid;
    }
}

