/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.relationship.SchemaRelationship;
import org.structr.core.entity.relationship.SchemaRelationshipSourceNode;
import org.structr.core.entity.relationship.SchemaRelationshipTargetNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNode;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;
import org.structr.module.StructrModule;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionEntry;
import org.structr.schema.action.Actions;
import org.structr.schema.parser.Validator;

public class SchemaNode
extends AbstractSchemaNode {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaNode.class.getName());
    private static final Set<String> EntityNameBlacklist = new LinkedHashSet<String>(Arrays.asList("Relation"));
    public static final Property<List<SchemaRelationshipNode>> relatedTo = new EndNodes("relatedTo", SchemaRelationshipSourceNode.class);
    public static final Property<List<SchemaRelationshipNode>> relatedFrom = new StartNodes("relatedFrom", SchemaRelationshipTargetNode.class);
    public static final Property<String> extendsClass = new StringProperty("extendsClass").indexed();
    public static final Property<String> defaultSortKey = new StringProperty("defaultSortKey");
    public static final Property<String> defaultSortOrder = new StringProperty("defaultSortOrder");
    public static final Property<Boolean> isBuiltinType = new BooleanProperty("isBuiltinType").readOnly().indexed();
    public static final Property<Integer> hierarchyLevel = new IntProperty("hierarchyLevel").indexed();
    public static final Property<Integer> relCount = new IntProperty("relCount").indexed();
    public static final Property<Boolean> shared = new BooleanProperty("shared").indexed();
    public static final View defaultView = new View(SchemaNode.class, "public", extendsClass, relatedTo, relatedFrom, defaultSortKey, defaultSortOrder, isBuiltinType, hierarchyLevel, relCount);
    public static final View uiView = new View(SchemaNode.class, "ui", name, extendsClass, relatedTo, relatedFrom, defaultSortKey, defaultSortOrder, isBuiltinType, hierarchyLevel, relCount);
    public static final View schemaView = new View(SchemaNode.class, "schema", name, extendsClass, relatedTo, relatedFrom, defaultSortKey, defaultSortOrder, isBuiltinType, hierarchyLevel, relCount);
    public static final View exportView = new View(SchemaNode.class, "export", extendsClass, defaultSortKey, defaultSortOrder, isBuiltinType, hierarchyLevel, relCount);
    private final Set<String> dynamicViews = new LinkedHashSet<String>();

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        this.throwExceptionIfTypeAlreadyExists();
        return super.onCreation(securityContext, errorBuffer);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (modificationQueue.isPropertyModified(this, name)) {
            this.throwExceptionIfTypeAlreadyExists();
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedList<StringProperty> propertyKeys = new LinkedList<StringProperty>(Iterables.toList(super.getPropertyKeys(propertyView)));
        for (String key : SchemaHelper.getProperties((PropertyContainer)this.getNode())) {
            StringProperty newKey = new StringProperty(key);
            newKey.setDeclaringClass(this.getClass());
            propertyKeys.add(newKey);
        }
        Collections.sort(propertyKeys, new Comparator<PropertyKey>(){

            @Override
            public int compare(PropertyKey o1, PropertyKey o2) {
                return o1.jsonName().compareTo(o2.jsonName());
            }
        });
        return new LinkedHashSet<PropertyKey>(propertyKeys);
    }

    @Override
    public String getSource(ErrorBuffer errorBuffer) throws FrameworkException {
        String propertyName;
        PropertyMap relNodeProperties;
        Collection<StructrModule> modules = StructrApp.getConfiguration().getModules().values();
        App app = StructrApp.getInstance(this.securityContext);
        EnumMap<Actions.Type, List<ActionEntry>> saveActions = new EnumMap<Actions.Type, List<ActionEntry>>(Actions.Type.class);
        LinkedHashMap<String, Set<String>> viewProperties = new LinkedHashMap<String, Set<String>>();
        LinkedHashSet<String> existingPropertyNames = new LinkedHashSet<String>();
        LinkedHashSet<String> compoundIndexKeys = new LinkedHashSet<String>();
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        LinkedHashSet<Validator> validators = new LinkedHashSet<Validator>();
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        StringBuilder src = new StringBuilder();
        Class<AbstractNode> baseType = AbstractNode.class;
        String _className = (String)this.getProperty(name);
        String _extendsClass = this.getProperty(extendsClass);
        String superClass = _extendsClass != null ? _extendsClass : baseType.getSimpleName();
        src.append("package org.structr.dynamic;\n\n");
        SchemaHelper.formatImportStatements(this, src, baseType);
        src.append("public class ");
        src.append(_className);
        src.append(" extends ");
        src.append(superClass);
        SchemaHelper.formatInterfacesFromModules(src, this);
        src.append(" {\n\n");
        for (SchemaRelationship schemaRelationship : this.getOutgoingRelationships(SchemaRelationship.class)) {
            relNodeProperties = new PropertyMap();
            relNodeProperties.put(SchemaRelationshipNode.sourceNode, schemaRelationship.getSourceNode());
            relNodeProperties.put(SchemaRelationshipNode.targetNode, schemaRelationship.getTargetNode());
            relNodeProperties.put(SchemaRelationshipNode.name, schemaRelationship.getProperty(SchemaRelationship.name));
            relNodeProperties.put(SchemaRelationshipNode.sourceNotion, schemaRelationship.getProperty(SchemaRelationship.sourceNotion));
            relNodeProperties.put(SchemaRelationshipNode.targetNotion, schemaRelationship.getProperty(SchemaRelationship.targetNotion));
            relNodeProperties.put(SchemaRelationshipNode.extendsClass, schemaRelationship.getProperty(SchemaRelationship.extendsClass));
            relNodeProperties.put(SchemaRelationshipNode.cascadingDeleteFlag, schemaRelationship.getProperty(SchemaRelationship.cascadingDeleteFlag));
            relNodeProperties.put(SchemaRelationshipNode.autocreationFlag, schemaRelationship.getProperty(SchemaRelationship.autocreationFlag));
            relNodeProperties.put(SchemaRelationshipNode.relationshipType, schemaRelationship.getProperty(SchemaRelationship.relationshipType));
            relNodeProperties.put(SchemaRelationshipNode.sourceMultiplicity, schemaRelationship.getProperty(SchemaRelationship.sourceMultiplicity));
            relNodeProperties.put(SchemaRelationshipNode.targetMultiplicity, schemaRelationship.getProperty(SchemaRelationship.targetMultiplicity));
            relNodeProperties.put(SchemaRelationshipNode.sourceJsonName, schemaRelationship.getProperty(SchemaRelationship.sourceJsonName));
            relNodeProperties.put(SchemaRelationshipNode.targetJsonName, schemaRelationship.getProperty(SchemaRelationship.targetJsonName));
            app.create(SchemaRelationshipNode.class, relNodeProperties);
            app.delete(schemaRelationship);
        }
        for (SchemaRelationship schemaRelationship : this.getIncomingRelationships(SchemaRelationship.class)) {
            relNodeProperties = new PropertyMap();
            relNodeProperties.put(SchemaRelationshipNode.sourceNode, schemaRelationship.getSourceNode());
            relNodeProperties.put(SchemaRelationshipNode.targetNode, schemaRelationship.getTargetNode());
            relNodeProperties.put(SchemaRelationshipNode.name, schemaRelationship.getProperty(SchemaRelationship.name));
            relNodeProperties.put(SchemaRelationshipNode.sourceNotion, schemaRelationship.getProperty(SchemaRelationship.sourceNotion));
            relNodeProperties.put(SchemaRelationshipNode.targetNotion, schemaRelationship.getProperty(SchemaRelationship.targetNotion));
            relNodeProperties.put(SchemaRelationshipNode.extendsClass, schemaRelationship.getProperty(SchemaRelationship.extendsClass));
            relNodeProperties.put(SchemaRelationshipNode.cascadingDeleteFlag, schemaRelationship.getProperty(SchemaRelationship.cascadingDeleteFlag));
            relNodeProperties.put(SchemaRelationshipNode.autocreationFlag, schemaRelationship.getProperty(SchemaRelationship.autocreationFlag));
            relNodeProperties.put(SchemaRelationshipNode.relationshipType, schemaRelationship.getProperty(SchemaRelationship.relationshipType));
            relNodeProperties.put(SchemaRelationshipNode.sourceMultiplicity, schemaRelationship.getProperty(SchemaRelationship.sourceMultiplicity));
            relNodeProperties.put(SchemaRelationshipNode.targetMultiplicity, schemaRelationship.getProperty(SchemaRelationship.targetMultiplicity));
            relNodeProperties.put(SchemaRelationshipNode.sourceJsonName, schemaRelationship.getProperty(SchemaRelationship.sourceJsonName));
            relNodeProperties.put(SchemaRelationshipNode.targetJsonName, schemaRelationship.getProperty(SchemaRelationship.targetJsonName));
            app.create(SchemaRelationshipNode.class, relNodeProperties);
            app.delete(schemaRelationship);
        }
        for (SchemaRelationshipNode schemaRelationshipNode : this.getProperty(relatedTo)) {
            propertyName = schemaRelationshipNode.getPropertyName(_className, existingPropertyNames, true);
            src.append(schemaRelationshipNode.getPropertySource(propertyName, true));
            this.addPropertyNameToViews(propertyName, viewProperties);
        }
        for (SchemaRelationshipNode schemaRelationshipNode : this.getProperty(relatedFrom)) {
            propertyName = schemaRelationshipNode.getPropertyName(_className, existingPropertyNames, false);
            src.append(schemaRelationshipNode.getPropertySource(propertyName, false));
            this.addPropertyNameToViews(propertyName, viewProperties);
        }
        src.append(SchemaHelper.extractProperties(this, propertyNames, validators, compoundIndexKeys, enums, viewProperties, errorBuffer));
        SchemaHelper.extractViews(this, viewProperties, errorBuffer);
        SchemaHelper.extractMethods(this, saveActions);
        for (String string : enums) {
            src.append(string);
        }
        for (Map.Entry entry : viewProperties.entrySet()) {
            String viewName = (String)entry.getKey();
            Set view = (Set)entry.getValue();
            if (view.isEmpty()) continue;
            this.dynamicViews.add(viewName);
            SchemaHelper.formatView(src, _className, viewName, viewName, view);
        }
        if (this.getProperty(defaultSortKey) != null) {
            String order = this.getProperty(defaultSortOrder);
            order = order == null || "desc".equals(order) ? "GraphObjectComparator.DESCENDING" : "GraphObjectComparator.ASCENDING";
            src.append("\n\t@Override\n");
            src.append("\tpublic PropertyKey getDefaultSortKey() {\n");
            src.append("\t\treturn ").append(this.getProperty(defaultSortKey)).append("Property;\n");
            src.append("\t}\n");
            src.append("\n\t@Override\n");
            src.append("\tpublic String getDefaultSortOrder() {\n");
            src.append("\t\treturn ").append(order).append(";\n");
            src.append("\t}\n");
        }
        SchemaHelper.formatValidators(src, validators, compoundIndexKeys);
        SchemaHelper.formatSaveActions(this, src, saveActions);
        for (StructrModule structrModule : modules) {
            src.append("\n\n// ----- dynamic code inserted by ");
            src.append(structrModule.getName());
            src.append(" -----\n");
            structrModule.insertSourceCode(this, src);
        }
        src.append("}\n");
        return src.toString();
    }

    @Override
    public Set<String> getViews() {
        return this.dynamicViews;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= ValidationHelper.isValidUniqueProperty(this, name, errorBuffer);
        return valid &= ValidationHelper.isValidStringMatchingRegex(this, name, "[A-Z][a-zA-Z0-9_]+", errorBuffer);
    }

    @Override
    public String getMultiplicity(String propertyNameToCheck) {
        String multiplicity = this.getMultiplicity(this, propertyNameToCheck);
        if (multiplicity == null) {
            try {
                SchemaNode parentSchemaNode;
                String parentClass = this.getProperty(extendsClass);
                if (parentClass != null && (parentSchemaNode = StructrApp.getInstance().nodeQuery(SchemaNode.class).andName(StringUtils.substringAfterLast((String)parentClass, (String)".")).getFirst()) != null) {
                    multiplicity = this.getMultiplicity(parentSchemaNode, propertyNameToCheck);
                }
            }
            catch (FrameworkException ex) {
                logger.warn("Can't find schema node for parent class!", (Throwable)ex);
            }
        }
        if (multiplicity != null) {
            return multiplicity;
        }
        PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(NodeInterface.class, propertyNameToCheck, false);
        if (key != null) {
            if (key instanceof StartNode || key instanceof EndNode) {
                return "1X";
            }
            if (key instanceof StartNodes || key instanceof EndNodes) {
                return "*X";
            }
        }
        return null;
    }

    private String getMultiplicity(SchemaNode schemaNode, String propertyNameToCheck) {
        LinkedHashSet<String> existingPropertyNames = new LinkedHashSet<String>();
        String _className = (String)schemaNode.getProperty(name);
        for (SchemaRelationshipNode outRel : schemaNode.getProperty(relatedTo)) {
            if (!propertyNameToCheck.equals(outRel.getPropertyName(_className, existingPropertyNames, true))) continue;
            return outRel.getMultiplicity(true);
        }
        for (SchemaRelationshipNode inRel : schemaNode.getProperty(relatedFrom)) {
            if (!propertyNameToCheck.equals(inRel.getPropertyName(_className, existingPropertyNames, false))) continue;
            return inRel.getMultiplicity(false);
        }
        return null;
    }

    @Override
    public String getRelatedType(String propertyNameToCheck) {
        Class relatedTypeClass;
        String relatedType = this.getRelatedType(this, propertyNameToCheck);
        if (relatedType == null) {
            try {
                SchemaNode parentSchemaNode;
                String parentClass = this.getProperty(extendsClass);
                if (parentClass != null && (parentSchemaNode = StructrApp.getInstance().nodeQuery(SchemaNode.class).andName(StringUtils.substringAfterLast((String)parentClass, (String)".")).getFirst()) != null) {
                    relatedType = this.getRelatedType(parentSchemaNode, propertyNameToCheck);
                }
            }
            catch (FrameworkException ex) {
                logger.warn("Can't find schema node for parent class!", (Throwable)ex);
            }
        }
        if (relatedType != null) {
            return relatedType;
        }
        PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(NodeInterface.class, propertyNameToCheck, false);
        if (key != null && (relatedTypeClass = key.relatedType()) != null) {
            return relatedTypeClass.getSimpleName();
        }
        return null;
    }

    private String getRelatedType(SchemaNode schemaNode, String propertyNameToCheck) {
        LinkedHashSet<String> existingPropertyNames = new LinkedHashSet<String>();
        String _className = (String)schemaNode.getProperty(name);
        for (SchemaRelationshipNode outRel : schemaNode.getProperty(relatedTo)) {
            if (!propertyNameToCheck.equals(outRel.getPropertyName(_className, existingPropertyNames, true))) continue;
            return outRel.getSchemaNodeTargetType();
        }
        for (SchemaRelationshipNode inRel : schemaNode.getProperty(relatedFrom)) {
            if (!propertyNameToCheck.equals(inRel.getPropertyName(_className, existingPropertyNames, false))) continue;
            return inRel.getSchemaNodeSourceType();
        }
        return null;
    }

    @Override
    public String getAuxiliarySource() throws FrameworkException {
        if (!"File".equals(this.getClassName()) && !"Image".equals(this.getClassName())) {
            return null;
        }
        EnumMap<Actions.Type, List<ActionEntry>> saveActions = new EnumMap<Actions.Type, List<ActionEntry>>(Actions.Type.class);
        LinkedHashMap<String, Set<String>> viewProperties = new LinkedHashMap<String, Set<String>>();
        LinkedHashSet<String> compoundIndexKeys = new LinkedHashSet<String>();
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        LinkedHashSet<Validator> validators = new LinkedHashSet<Validator>();
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        String _className = (String)this.getProperty(name);
        ErrorBuffer dummyErrorBuffer = new ErrorBuffer();
        String propertyDefinitions = SchemaHelper.extractProperties(this, propertyNames, validators, compoundIndexKeys, enums, viewProperties, dummyErrorBuffer);
        SchemaHelper.extractViews(this, viewProperties, dummyErrorBuffer);
        SchemaHelper.extractMethods(this, saveActions);
        if (!propertyNames.isEmpty() || !viewProperties.isEmpty() || validators.isEmpty() || !saveActions.isEmpty()) {
            StringBuilder src = new StringBuilder();
            src.append("package org.structr.dynamic;\n\n");
            SchemaHelper.formatImportStatements(this, src, AbstractNode.class);
            src.append("public class _").append(_className).append("Helper {\n");
            for (String enumDefition : enums) {
                src.append(enumDefition);
            }
            if (!enums.isEmpty()) {
                src.append("\n");
            }
            if (!propertyNames.isEmpty()) {
                src.append("\n");
                src.append(propertyDefinitions);
                src.append("\n\tstatic {\n\n");
                for (String name : propertyNames) {
                    String propertyName = name + "Property";
                    src.append("\t\t").append(propertyName).append(".setDeclaringClass(").append(_className).append(".class);\n\n");
                    src.append("\t\tStructrApp.getConfiguration().registerDynamicProperty(").append(_className).append(".class, ").append(propertyName).append(");\n");
                    src.append("\t\tStructrApp.getConfiguration().registerPropertySet(").append(_className).append(".class, PropertyView.Ui, ").append(propertyName).append(");\n\n");
                }
                for (String viewName : viewProperties.keySet()) {
                    for (String propertyName : (Set)viewProperties.get(viewName)) {
                        if (propertyName.endsWith("Property")) {
                            propertyName = propertyName.substring(0, propertyName.length() - 8);
                        }
                        src.append("\t\tStructrApp.getConfiguration().registerPropertySet(").append(_className).append(".class, \"").append(viewName).append("\", \"").append(propertyName).append("\");\n\n");
                    }
                }
                src.append("\t}\n\n");
            }
            SchemaHelper.formatDynamicValidators(src, validators, compoundIndexKeys);
            SchemaHelper.formatDynamicSaveActions(src, saveActions);
            src.append("}\n");
            return src.toString();
        }
        return null;
    }

    private void addPropertyNameToViews(String propertyName, Map<String, Set<String>> viewProperties) {
        SchemaHelper.addPropertyToView("ui", propertyName, viewProperties);
    }

    private void throwExceptionIfTypeAlreadyExists() throws FrameworkException {
        if (Services.getInstance().isInitialized() && !Services.getInstance().isOverridingSchemaTypesAllowed()) {
            String typeName = (String)this.getProperty(name);
            if (EntityNameBlacklist.contains(typeName)) {
                throw new FrameworkException(422, "Type '" + typeName + "' already exists. To prevent unwanted/unexpected behavior this is forbidden.");
            }
            if (StructrApp.getConfiguration().getNodeEntities().containsKey(typeName)) {
                throw new FrameworkException(422, "Type '" + typeName + "' already exists. To prevent unwanted/unexpected behavior this is forbidden.");
            }
            if (StructrApp.getConfiguration().getInterfaces().containsKey(typeName)) {
                throw new FrameworkException(422, "Type '" + typeName + "' already exists. To prevent unwanted/unexpected behavior this is forbidden.");
            }
        }
    }

    @Override
    public List<GraphObject> getSyncData() throws FrameworkException {
        List<GraphObject> data = super.getSyncData();
        data.addAll(StructrApp.getInstance(this.securityContext).nodeQuery(SchemaNode.class).getAsList());
        for (SchemaRelationshipNode rel : this.getProperty(relatedTo)) {
            data.add(rel);
        }
        for (SchemaRelationshipNode rel : this.getProperty(relatedFrom)) {
            data.add(rel);
        }
        return data;
    }
}

