/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.util.Iterables;
import org.structr.common.CaseHelper;
import org.structr.common.PermissionPropagation;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaView;
import org.structr.core.entity.relationship.Ownership;
import org.structr.core.entity.relationship.SchemaRelationshipSourceNode;
import org.structr.core.entity.relationship.SchemaRelationshipTargetNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.notion.PropertyNotion;
import org.structr.core.property.EndNode;
import org.structr.core.property.EntityNotionProperty;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.schema.ReloadSchema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionEntry;
import org.structr.schema.action.Actions;
import org.structr.schema.json.JsonSchema;
import org.structr.schema.parser.Validator;

public class SchemaRelationshipNode
extends AbstractSchemaNode {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaRelationshipNode.class.getName());
    private static final Set<Class> propagatingRelTypes = new HashSet<Class>();
    private static final Pattern ValidKeyPattern = Pattern.compile("[a-zA-Z_]+");
    public static final Property<SchemaNode> sourceNode = new StartNode("sourceNode", SchemaRelationshipSourceNode.class);
    public static final Property<SchemaNode> targetNode = new EndNode("targetNode", SchemaRelationshipTargetNode.class);
    public static final Property<String> sourceId = new EntityNotionProperty<SchemaNode, String>("sourceId", sourceNode, new PropertyNotion(GraphObject.id));
    public static final Property<String> targetId = new EntityNotionProperty<SchemaNode, String>("targetId", targetNode, new PropertyNotion(GraphObject.id));
    public static final Property<String> name = new StringProperty("name").indexed();
    public static final Property<String> relationshipType = new StringProperty("relationshipType").indexed();
    public static final Property<String> sourceMultiplicity = new StringProperty("sourceMultiplicity");
    public static final Property<String> targetMultiplicity = new StringProperty("targetMultiplicity");
    public static final Property<String> sourceNotion = new StringProperty("sourceNotion");
    public static final Property<String> targetNotion = new StringProperty("targetNotion");
    public static final Property<String> sourceJsonName = new StringProperty("sourceJsonName");
    public static final Property<String> targetJsonName = new StringProperty("targetJsonName");
    public static final Property<String> previousSourceJsonName = new StringProperty("oldSourceJsonName");
    public static final Property<String> previousTargetJsonName = new StringProperty("oldTargetJsonName");
    public static final Property<String> extendsClass = new StringProperty("extendsClass").indexed();
    public static final Property<Long> cascadingDeleteFlag = new LongProperty("cascadingDeleteFlag");
    public static final Property<Long> autocreationFlag = new LongProperty("autocreationFlag");
    public static final Property<Direction> permissionPropagation = new EnumProperty<Direction>("permissionPropagation", Direction.class, Direction.None);
    public static final Property<Propagation> readPropagation = new EnumProperty<Propagation>("readPropagation", Propagation.class, Propagation.Remove);
    public static final Property<Propagation> writePropagation = new EnumProperty<Propagation>("writePropagation", Propagation.class, Propagation.Remove);
    public static final Property<Propagation> deletePropagation = new EnumProperty<Propagation>("deletePropagation", Propagation.class, Propagation.Remove);
    public static final Property<Propagation> accessControlPropagation = new EnumProperty<Propagation>("accessControlPropagation", Propagation.class, Propagation.Remove);
    public static final Property<String> propertyMask = new StringProperty("propertyMask");
    public static final View defaultView = new View(SchemaRelationshipNode.class, "public", name, sourceId, targetId, sourceMultiplicity, targetMultiplicity, sourceNotion, targetNotion, relationshipType, sourceJsonName, targetJsonName, extendsClass, cascadingDeleteFlag, autocreationFlag, previousSourceJsonName, previousTargetJsonName, permissionPropagation, readPropagation, writePropagation, deletePropagation, accessControlPropagation, propertyMask);
    public static final View uiView = new View(SchemaRelationshipNode.class, "ui", name, sourceId, targetId, sourceMultiplicity, targetMultiplicity, sourceNotion, targetNotion, relationshipType, sourceJsonName, targetJsonName, extendsClass, cascadingDeleteFlag, autocreationFlag, previousSourceJsonName, previousTargetJsonName, permissionPropagation, readPropagation, writePropagation, deletePropagation, accessControlPropagation, propertyMask);
    public static final View exportView = new View(SchemaRelationshipNode.class, "export", sourceId, targetId, sourceMultiplicity, targetMultiplicity, sourceNotion, targetNotion, relationshipType, sourceJsonName, targetJsonName, extendsClass, cascadingDeleteFlag, autocreationFlag, permissionPropagation, propertyMask);
    private final Set<String> dynamicViews = new LinkedHashSet<String>();

    public static void registerPropagatingRelationshipType(Class type) {
        propagatingRelTypes.add(type);
    }

    public static void clearPropagatingRelationshipTypes() {
        propagatingRelTypes.clear();
    }

    public static Set<Class> getPropagatingRelationshipTypes() {
        return propagatingRelTypes;
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedHashSet<PropertyKey> propertyKeys = new LinkedHashSet<PropertyKey>(Iterables.toList(super.getPropertyKeys(propertyView)));
        for (String key : SchemaHelper.getProperties((PropertyContainer)this.getNode())) {
            StringProperty newKey = new StringProperty(key);
            newKey.setDeclaringClass(this.getClass());
            propertyKeys.add(newKey);
        }
        return propertyKeys;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= ValidationHelper.isValidStringNotBlank(this, relationshipType, errorBuffer);
        valid &= ValidationHelper.isValidPropertyNotNull(this, sourceNode, errorBuffer);
        return valid &= ValidationHelper.isValidPropertyNotNull(this, targetNode, errorBuffer);
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            this.setProperty(previousSourceJsonName, this.getProperty(sourceJsonName));
            this.setProperty(previousTargetJsonName, this.getProperty(targetJsonName));
            TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            this.checkClassName();
            this.checkAndRenameSourceAndTargetJsonNames();
            this.setProperty(previousSourceJsonName, this.getProperty(sourceJsonName));
            this.setProperty(previousTargetJsonName, this.getProperty(targetJsonName));
            TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
            return true;
        }
        return false;
    }

    @Override
    public void onNodeDeletion() {
        try {
            this.removeSourceAndTargetJsonNames();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }

    @Override
    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) throws FrameworkException {
        if (super.onDeletion(securityContext, errorBuffer, properties)) {
            TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
            return true;
        }
        return false;
    }

    public SchemaNode getSourceNode() {
        return this.getProperty(sourceNode);
    }

    public SchemaNode getTargetNode() {
        return this.getProperty(targetNode);
    }

    @Override
    public String getClassName() {
        String name = (String)this.getProperty(AbstractNode.name);
        if (name == null) {
            String _sourceType = this.getSchemaNodeSourceType();
            String _targetType = this.getSchemaNodeTargetType();
            String _relType = SchemaHelper.cleanPropertyName(this.getRelationshipType());
            name = _sourceType + _relType + _targetType;
            try {
                this.setProperty(AbstractNode.name, name);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set relationship name to {}.", (Object)name);
            }
        }
        return name;
    }

    @Override
    public String getMultiplicity(String propertyNameToCheck) {
        return null;
    }

    @Override
    public String getRelatedType(String propertyNameToCheck) {
        return null;
    }

    public String getPropertySource(String propertyName, boolean outgoing) {
        return this.getPropertySource(propertyName, outgoing, false);
    }

    public String getPropertySource(String propertyName, boolean outgoing, boolean newStatementOnly) {
        StringBuilder buf = new StringBuilder();
        String _sourceMultiplicity = this.getProperty(sourceMultiplicity);
        String _targetMultiplicity = this.getProperty(targetMultiplicity);
        String _sourceNotion = this.getProperty(sourceNotion);
        String _targetNotion = this.getProperty(targetNotion);
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        String _className = this.getClassName();
        if (outgoing) {
            if ("1".equals(_targetMultiplicity)) {
                if (!newStatementOnly) {
                    buf.append("\tpublic static final Property<").append(_targetType).append("> ").append(SchemaHelper.cleanPropertyName(propertyName)).append("Property");
                    buf.append(" = ");
                }
                buf.append("new EndNode<>(\"").append(propertyName).append("\", ").append(_className).append(".class");
                buf.append(this.getNotion(_sourceType, _targetNotion));
                buf.append(newStatementOnly ? ")" : ").dynamic();\n");
            } else {
                if (!newStatementOnly) {
                    buf.append("\tpublic static final Property<java.util.List<").append(_targetType).append(">> ").append(SchemaHelper.cleanPropertyName(propertyName)).append("Property");
                    buf.append(" = ");
                }
                buf.append("new EndNodes<>(\"").append(propertyName).append("\", ").append(_className).append(".class");
                buf.append(this.getNotion(_sourceType, _targetNotion));
                buf.append(newStatementOnly ? ")" : ").dynamic();\n");
            }
        } else if ("1".equals(_sourceMultiplicity)) {
            if (!newStatementOnly) {
                buf.append("\tpublic static final Property<").append(_sourceType).append("> ").append(SchemaHelper.cleanPropertyName(propertyName)).append("Property");
                buf.append(" = ");
            }
            buf.append("new StartNode<>(\"").append(propertyName).append("\", ").append(_className).append(".class");
            buf.append(this.getNotion(_targetType, _sourceNotion));
            buf.append(newStatementOnly ? ")" : ").dynamic();\n");
        } else {
            if (!newStatementOnly) {
                buf.append("\tpublic static final Property<java.util.List<").append(_sourceType).append(">> ").append(SchemaHelper.cleanPropertyName(propertyName)).append("Property");
                buf.append(" = ");
            }
            buf.append("new StartNodes<>(\"").append(propertyName).append("\", ").append(_className).append(".class");
            buf.append(this.getNotion(_targetType, _sourceNotion));
            buf.append(newStatementOnly ? ")" : ").dynamic();\n");
        }
        return buf.toString();
    }

    public String getMultiplicity(boolean outgoing) {
        if (outgoing) {
            return this.getProperty(targetMultiplicity);
        }
        return this.getProperty(sourceMultiplicity);
    }

    public String getPropertyName(String relatedClassName, Set<String> existingPropertyNames, boolean outgoing) {
        String relationshipTypeName = this.getProperty(relationshipType).toLowerCase();
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        String _targetJsonName = this.getProperty(targetJsonName);
        String _targetMultiplicity = this.getProperty(targetMultiplicity);
        String _sourceJsonName = this.getProperty(sourceJsonName);
        String _sourceMultiplicity = this.getProperty(sourceMultiplicity);
        String propertyName = SchemaRelationshipNode.getPropertyName(relatedClassName, existingPropertyNames, outgoing, relationshipTypeName, _sourceType, _targetType, _targetJsonName, _targetMultiplicity, _sourceJsonName, _sourceMultiplicity);
        try {
            if (outgoing) {
                if (_targetJsonName == null) {
                    this.setProperty(previousTargetJsonName, propertyName);
                }
            } else if (_sourceJsonName == null) {
                this.setProperty(previousSourceJsonName, propertyName);
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return propertyName;
    }

    public static String getPropertyName(String relatedClassName, Set<String> existingPropertyNames, boolean outgoing, String relationshipTypeName, String _sourceType, String _targetType, String _targetJsonName, String _targetMultiplicity, String _sourceJsonName, String _sourceMultiplicity) {
        String propertyName = "";
        propertyName = outgoing ? (_targetJsonName != null ? _targetJsonName : ("1".equals(_targetMultiplicity) ? CaseHelper.toLowerCamelCase(relationshipTypeName) + CaseHelper.toUpperCamelCase(_targetType) : CaseHelper.plural(CaseHelper.toLowerCamelCase(relationshipTypeName) + CaseHelper.toUpperCamelCase(_targetType)))) : (_sourceJsonName != null ? _sourceJsonName : ("1".equals(_sourceMultiplicity) ? CaseHelper.toLowerCamelCase(_sourceType) + CaseHelper.toUpperCamelCase(relationshipTypeName) : CaseHelper.plural(CaseHelper.toLowerCamelCase(_sourceType) + CaseHelper.toUpperCamelCase(relationshipTypeName))));
        if (existingPropertyNames.contains(propertyName)) {
            propertyName = propertyName + (outgoing ? "Out" : "In");
            int i = 0;
            while (existingPropertyNames.contains(propertyName)) {
                propertyName = propertyName + ++i;
            }
        }
        existingPropertyNames.add(propertyName);
        return propertyName;
    }

    @Override
    public String getSource(ErrorBuffer errorBuffer) throws FrameworkException {
        LinkedHashMap<Actions.Type, List<ActionEntry>> actions = new LinkedHashMap<Actions.Type, List<ActionEntry>>();
        LinkedHashMap<String, Set<String>> viewProperties = new LinkedHashMap<String, Set<String>>();
        StringBuilder src = new StringBuilder();
        Class<AbstractRelationship> baseType = AbstractRelationship.class;
        String _className = this.getClassName();
        String _sourceNodeType = this.getSchemaNodeSourceType();
        String _targetNodeType = this.getSchemaNodeTargetType();
        LinkedHashSet<String> compoundIndexKeys = new LinkedHashSet<String>();
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        LinkedHashSet<Validator> validators = new LinkedHashSet<Validator>();
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        src.append("package org.structr.dynamic;\n\n");
        SchemaHelper.formatImportStatements(this, src, baseType);
        src.append("public class ").append(_className).append(" extends ").append(this.getBaseType());
        if ("OWNS".equals(this.getProperty(relationshipType))) {
            interfaces.add(Ownership.class.getName());
        }
        if (!Direction.None.equals((Object)this.getProperty(permissionPropagation))) {
            interfaces.add(PermissionPropagation.class.getName());
        }
        if (!interfaces.isEmpty()) {
            src.append(" implements ");
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                src.append((String)it.next());
                if (!it.hasNext()) continue;
                src.append(", ");
            }
        }
        src.append(" {\n\n");
        if (!Direction.None.equals((Object)this.getProperty(permissionPropagation))) {
            src.append("\tstatic {\n\t\tSchemaRelationshipNode.registerPropagatingRelationshipType(").append(_className).append(".class);\n\t}\n\n");
        }
        src.append(SchemaHelper.extractProperties(this, propertyNames, validators, compoundIndexKeys, enums, viewProperties, errorBuffer));
        SchemaHelper.extractViews(this, viewProperties, errorBuffer);
        SchemaHelper.extractMethods(this, actions);
        src.append("\tpublic static final Property<java.lang.String> sourceIdProperty = new SourceId(\"sourceId\");\n");
        src.append("\tpublic static final Property<java.lang.String> targetIdProperty = new TargetId(\"targetId\");\n");
        SchemaHelper.addPropertyToView("ui", "sourceId", viewProperties);
        SchemaHelper.addPropertyToView("ui", "targetId", viewProperties);
        for (String string : enums) {
            src.append(string);
        }
        for (Map.Entry entry : viewProperties.entrySet()) {
            String viewName = (String)entry.getKey();
            Set view = (Set)entry.getValue();
            if (view.isEmpty()) continue;
            this.dynamicViews.add(viewName);
            SchemaHelper.formatView(src, _className, viewName, viewName, view);
        }
        src.append("\n\t@Override\n");
        src.append("\tpublic Class<").append(_sourceNodeType).append("> getSourceType() {\n");
        src.append("\t\treturn ").append(_sourceNodeType).append(".class;\n");
        src.append("\t}\n\n");
        src.append("\t@Override\n");
        src.append("\tpublic Class<").append(_targetNodeType).append("> getTargetType() {\n");
        src.append("\t\treturn ").append(_targetNodeType).append(".class;\n");
        src.append("\t}\n\n");
        src.append("\t@Override\n");
        src.append("\tpublic Property<java.lang.String> getSourceIdProperty() {\n");
        src.append("\t\treturn sourceId;\n");
        src.append("\t}\n\n");
        src.append("\t@Override\n");
        src.append("\tpublic Property<java.lang.String> getTargetIdProperty() {\n");
        src.append("\t\treturn targetId;\n");
        src.append("\t}\n\n");
        src.append("\t@Override\n");
        src.append("\tpublic java.lang.String name() {\n");
        src.append("\t\treturn \"").append(this.getRelationshipType()).append("\";\n");
        src.append("\t}\n\n");
        SchemaHelper.formatValidators(src, validators, compoundIndexKeys);
        SchemaHelper.formatSaveActions(this, src, actions);
        this.formatRelationshipFlags(src);
        this.formatPermissionPropagation(src);
        src.append("}\n");
        return src.toString();
    }

    @Override
    public Set<String> getViews() {
        return this.dynamicViews;
    }

    @Override
    public String getAuxiliarySource() throws FrameworkException {
        LinkedHashSet<String> existingPropertyNames = new LinkedHashSet<String>();
        String sourceNodeType = this.getSchemaNodeSourceType();
        String targetNodeType = this.getSchemaNodeTargetType();
        StringBuilder src = new StringBuilder();
        String _className = this.getClassName();
        Class<AbstractRelationship> baseType = AbstractRelationship.class;
        if (!"File".equals(sourceNodeType) && !"File".equals(targetNodeType)) {
            return null;
        }
        src.append("package org.structr.dynamic;\n\n");
        SchemaHelper.formatImportStatements(this, src, baseType);
        src.append("public class _").append(_className).append("Helper {\n\n");
        src.append("\n\tstatic {\n\n");
        src.append("\t\tfinal PropertyKey outKey = ");
        src.append(this.getPropertySource(this.getPropertyName(sourceNodeType, existingPropertyNames, true), true, true));
        src.append(";\n");
        src.append("\t\toutKey.setDeclaringClass(").append(sourceNodeType).append(".class);\n\n");
        src.append("\t\tfinal PropertyKey inKey = ");
        src.append(this.getPropertySource(this.getPropertyName(targetNodeType, existingPropertyNames, false), false, true));
        src.append(";\n");
        src.append("\t\tinKey.setDeclaringClass(").append(targetNodeType).append(".class);\n\n");
        src.append("\t\tStructrApp.getConfiguration().registerDynamicProperty(");
        src.append(sourceNodeType).append(".class, outKey);\n");
        src.append("\t\tStructrApp.getConfiguration().registerDynamicProperty(");
        src.append(targetNodeType).append(".class, inKey);\n\n");
        src.append("\t\tStructrApp.getConfiguration().registerPropertySet(").append(sourceNodeType).append(".class, PropertyView.Ui, outKey);\n");
        src.append("\t\tStructrApp.getConfiguration().registerPropertySet(").append(targetNodeType).append(".class, PropertyView.Ui, inKey);\n");
        src.append("\t}\n");
        src.append("}\n");
        return src.toString();
    }

    public String getSchemaNodeSourceType() {
        SchemaNode sourceNode = this.getSourceNode();
        if (sourceNode != null) {
            return (String)sourceNode.getProperty(SchemaNode.name);
        }
        return null;
    }

    public String getSchemaNodeTargetType() {
        SchemaNode targetNode = this.getTargetNode();
        if (targetNode != null) {
            return (String)targetNode.getProperty(SchemaNode.name);
        }
        return null;
    }

    @Override
    public String getResourceSignature() {
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        return _sourceType + "/" + _targetType;
    }

    public String getInverseResourceSignature() {
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        return _targetType + "/" + _sourceType;
    }

    private String getRelationshipType() {
        String relType = this.getProperty(relationshipType);
        if (relType == null) {
            String _sourceType = this.getSchemaNodeSourceType().toUpperCase();
            String _targetType = this.getSchemaNodeTargetType().toUpperCase();
            relType = _sourceType + "_" + _targetType;
        }
        return relType;
    }

    private String getNotion(String _className, String notionSource) {
        LinkedHashSet<String> keys;
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)notionSource) && !(keys = new LinkedHashSet<String>(Arrays.asList(notionSource.split("[\\s,]+")))).isEmpty()) {
            if (keys.size() == 1) {
                String key = (String)keys.iterator().next();
                boolean create = key.startsWith("+");
                if (create) {
                    key = key.substring(1);
                }
                if (ValidKeyPattern.matcher(key).matches()) {
                    buf.append(", new PropertyNotion(");
                    buf.append(this.getNotionKey(_className, key));
                    buf.append(", ").append(create);
                    buf.append(")");
                } else {
                    logger.warn("Invalid key name {} for notion.", (Object)key);
                }
            } else {
                buf.append(", new PropertySetNotion(");
                Iterator it = Iterables.filter((Predicate)new KeyMatcher(), keys).iterator();
                while (it.hasNext()) {
                    buf.append(this.getNotionKey(_className, (String)it.next()));
                    if (!it.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
        }
        return buf.toString();
    }

    private String getNotionKey(String _className, String key) {
        return _className + "." + key;
    }

    private String getBaseType() {
        String _sourceMultiplicity = this.getProperty(sourceMultiplicity);
        String _targetMultiplicity = this.getProperty(targetMultiplicity);
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        StringBuilder buf = new StringBuilder();
        if ("1".equals(_sourceMultiplicity)) {
            if ("1".equals(_targetMultiplicity)) {
                buf.append("OneToOne");
            } else {
                buf.append("OneToMany");
            }
        } else if ("1".equals(_targetMultiplicity)) {
            buf.append("ManyToOne");
        } else {
            buf.append("ManyToMany");
        }
        buf.append("<");
        buf.append(_sourceType);
        buf.append(", ");
        buf.append(_targetType);
        buf.append(">");
        return buf.toString();
    }

    public void resolveCascadingEnums(JsonSchema.Cascade delete, JsonSchema.Cascade autoCreate) throws FrameworkException {
        if (delete != null) {
            switch (delete) {
                case sourceToTarget: {
                    this.setProperty(cascadingDeleteFlag, 1L);
                    break;
                }
                case targetToSource: {
                    this.setProperty(cascadingDeleteFlag, 2L);
                    break;
                }
                case always: {
                    this.setProperty(cascadingDeleteFlag, 3L);
                    break;
                }
                case constraintBased: {
                    this.setProperty(cascadingDeleteFlag, 4L);
                }
            }
        }
        if (autoCreate != null) {
            switch (autoCreate) {
                case sourceToTarget: {
                    this.setProperty(autocreationFlag, 1L);
                    break;
                }
                case targetToSource: {
                    this.setProperty(autocreationFlag, 2L);
                    break;
                }
                case always: {
                    this.setProperty(autocreationFlag, 3L);
                    break;
                }
                case constraintBased: {
                    this.setProperty(autocreationFlag, 4L);
                }
            }
        }
    }

    public Map<String, Object> resolveCascadingFlags() {
        Long cascadingDelete = this.getProperty(cascadingDeleteFlag);
        Long autoCreate = this.getProperty(autocreationFlag);
        TreeMap<String, Object> cascade = new TreeMap<String, Object>();
        if (cascadingDelete != null) {
            switch (cascadingDelete.intValue()) {
                case 1: {
                    cascade.put("delete", JsonSchema.Cascade.sourceToTarget.name());
                    break;
                }
                case 2: {
                    cascade.put("delete", JsonSchema.Cascade.targetToSource.name());
                    break;
                }
                case 3: {
                    cascade.put("delete", JsonSchema.Cascade.always.name());
                    break;
                }
                case 4: {
                    cascade.put("delete", JsonSchema.Cascade.constraintBased.name());
                }
            }
        }
        if (autoCreate != null) {
            switch (autoCreate.intValue()) {
                case 1: {
                    cascade.put("create", JsonSchema.Cascade.sourceToTarget.name());
                    break;
                }
                case 2: {
                    cascade.put("create", JsonSchema.Cascade.targetToSource.name());
                    break;
                }
                case 3: {
                    cascade.put("create", JsonSchema.Cascade.always.name());
                    break;
                }
                case 4: {
                    cascade.put("create", JsonSchema.Cascade.constraintBased.name());
                }
            }
        }
        return cascade;
    }

    @Override
    public List<GraphObject> getSyncData() throws FrameworkException {
        List<GraphObject> syncables = super.getSyncData();
        syncables.add(this.getSourceNode());
        syncables.add(this.getTargetNode());
        syncables.add(this.getIncomingRelationship(SchemaRelationshipSourceNode.class));
        syncables.add(this.getOutgoingRelationship(SchemaRelationshipTargetNode.class));
        return syncables;
    }

    private void formatRelationshipFlags(StringBuilder src) {
        Long autocreate;
        Long cascadingDelete = this.getProperty(cascadingDeleteFlag);
        if (cascadingDelete != null) {
            src.append("\n\t@Override\n");
            src.append("\tpublic int getCascadingDeleteFlag() {\n");
            switch (cascadingDelete.intValue()) {
                case 3: {
                    src.append("\t\treturn Relation.ALWAYS;\n");
                    break;
                }
                case 4: {
                    src.append("\t\treturn Relation.CONSTRAINT_BASED;\n");
                    break;
                }
                case 1: {
                    src.append("\t\treturn Relation.SOURCE_TO_TARGET;\n");
                    break;
                }
                case 2: {
                    src.append("\t\treturn Relation.TARGET_TO_SOURCE;\n");
                    break;
                }
                default: {
                    src.append("\t\treturn Relation.NONE;\n");
                }
            }
            src.append("\t}\n\n");
        }
        if ((autocreate = this.getProperty(autocreationFlag)) != null) {
            src.append("\n\t@Override\n");
            src.append("\tpublic int getAutocreationFlag() {\n");
            switch (autocreate.intValue()) {
                case 3: {
                    src.append("\t\treturn Relation.ALWAYS;\n");
                    break;
                }
                case 1: {
                    src.append("\t\treturn Relation.SOURCE_TO_TARGET;\n");
                    break;
                }
                case 2: {
                    src.append("\t\treturn Relation.TARGET_TO_SOURCE;\n");
                    break;
                }
                default: {
                    src.append("\t\treturn Relation.NONE;\n");
                }
            }
            src.append("\t}\n\n");
        }
    }

    private void formatPermissionPropagation(StringBuilder buf) {
        if (!Direction.None.equals((Object)this.getProperty(permissionPropagation))) {
            buf.append("\n\t@Override\n");
            buf.append("\tpublic SchemaRelationshipNode.Direction getPropagationDirection() {\n");
            buf.append("\t\treturn SchemaRelationshipNode.Direction.").append((Object)this.getProperty(permissionPropagation)).append(";\n");
            buf.append("\t}\n\n");
            buf.append("\n\t@Override\n");
            buf.append("\tpublic SchemaRelationshipNode.Propagation getReadPropagation() {\n");
            buf.append("\t\treturn SchemaRelationshipNode.Propagation.").append((Object)this.getProperty(readPropagation)).append(";\n");
            buf.append("\t}\n\n");
            buf.append("\n\t@Override\n");
            buf.append("\tpublic SchemaRelationshipNode.Propagation getWritePropagation() {\n");
            buf.append("\t\treturn SchemaRelationshipNode.Propagation.").append((Object)this.getProperty(writePropagation)).append(";\n");
            buf.append("\t}\n\n");
            buf.append("\n\t@Override\n");
            buf.append("\tpublic SchemaRelationshipNode.Propagation getDeletePropagation() {\n");
            buf.append("\t\treturn SchemaRelationshipNode.Propagation.").append((Object)this.getProperty(deletePropagation)).append(";\n");
            buf.append("\t}\n\n");
            buf.append("\n\t@Override\n");
            buf.append("\tpublic SchemaRelationshipNode.Propagation getAccessControlPropagation() {\n");
            buf.append("\t\treturn SchemaRelationshipNode.Propagation.").append((Object)this.getProperty(accessControlPropagation)).append(";\n");
            buf.append("\t}\n\n");
            buf.append("\n\t@Override\n");
            buf.append("\tpublic String getDeltaProperties() {\n");
            String _propertyMask = this.getProperty(propertyMask);
            if (_propertyMask != null) {
                buf.append("\t\treturn \"").append(_propertyMask).append("\";\n");
            } else {
                buf.append("\t\treturn null;\n");
            }
            buf.append("\t}\n\n");
        }
    }

    private void checkClassName() throws FrameworkException {
        String potentialNewClassName;
        String className = this.getClassName();
        if (!className.equals(potentialNewClassName = this.assembleNewClassName())) {
            try {
                this.setProperty(AbstractNode.name, potentialNewClassName);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set relationship name to {}.", (Object)potentialNewClassName);
            }
        }
    }

    private String assembleNewClassName() {
        String _sourceType = this.getSchemaNodeSourceType();
        String _targetType = this.getSchemaNodeTargetType();
        String _relType = SchemaHelper.cleanPropertyName(this.getRelationshipType());
        return _sourceType + _relType + _targetType;
    }

    private void checkAndRenameSourceAndTargetJsonNames() throws FrameworkException {
        String _previousSourceJsonName = this.getProperty(previousSourceJsonName);
        String _previousTargetJsonName = this.getProperty(previousTargetJsonName);
        String _currentSourceJsonName = this.getProperty(sourceJsonName) != null ? this.getProperty(sourceJsonName) : this.getPropertyName(this.getSchemaNodeTargetType(), new LinkedHashSet<String>(), false);
        String _currentTargetJsonName = this.getProperty(targetJsonName) != null ? this.getProperty(targetJsonName) : this.getPropertyName(this.getSchemaNodeSourceType(), new LinkedHashSet<String>(), true);
        SchemaNode _sourceNode = this.getProperty(sourceNode);
        SchemaNode _targetNode = this.getProperty(targetNode);
        if (_previousSourceJsonName != null && _currentSourceJsonName != null && !_currentSourceJsonName.equals(_previousSourceJsonName)) {
            this.renameNameInNonGraphProperties(_targetNode, _previousSourceJsonName, _currentSourceJsonName);
            this.renameNotionPropertyReferences(_sourceNode, _previousSourceJsonName, _currentSourceJsonName);
            this.renameNotionPropertyReferences(_targetNode, _previousSourceJsonName, _currentSourceJsonName);
        }
        if (_previousTargetJsonName != null && _currentTargetJsonName != null && !_currentTargetJsonName.equals(_previousTargetJsonName)) {
            this.renameNameInNonGraphProperties(_sourceNode, _previousTargetJsonName, _currentTargetJsonName);
            this.renameNotionPropertyReferences(_sourceNode, _previousTargetJsonName, _currentTargetJsonName);
            this.renameNotionPropertyReferences(_targetNode, _previousTargetJsonName, _currentTargetJsonName);
        }
    }

    private void removeSourceAndTargetJsonNames() throws FrameworkException {
        String _currentTargetJsonName;
        SchemaNode _sourceNode = this.getProperty(sourceNode);
        SchemaNode _targetNode = this.getProperty(targetNode);
        String _currentSourceJsonName = this.getProperty(sourceJsonName) != null ? this.getProperty(sourceJsonName) : this.getPropertyName(this.getSchemaNodeTargetType(), new LinkedHashSet<String>(), false);
        String string = _currentTargetJsonName = this.getProperty(targetJsonName) != null ? this.getProperty(targetJsonName) : this.getPropertyName(this.getSchemaNodeSourceType(), new LinkedHashSet<String>(), true);
        if (_sourceNode != null) {
            this.removeNameFromNonGraphProperties(_sourceNode, _currentSourceJsonName);
            this.removeNameFromNonGraphProperties(_sourceNode, _currentTargetJsonName);
        }
        if (_targetNode != null) {
            this.removeNameFromNonGraphProperties(_targetNode, _currentSourceJsonName);
            this.removeNameFromNonGraphProperties(_targetNode, _currentTargetJsonName);
        }
    }

    private void renameNotionPropertyReferences(SchemaNode schemaNode, String previousValue, String currentValue) throws FrameworkException {
        for (SchemaProperty property : schemaNode.getSchemaProperties()) {
            String basePropertyName;
            if (!SchemaHelper.Type.Notion.equals((Object)property.getPropertyType()) || !(basePropertyName = property.getNotionBaseProperty()).equals(previousValue)) continue;
            property.setProperty(SchemaProperty.format, property.getFormat().replace(previousValue, currentValue));
        }
    }

    private void renameNameInNonGraphProperties(AbstractSchemaNode schemaNode, String toRemove, String newValue) throws FrameworkException {
        for (SchemaView view : schemaNode.getSchemaViews()) {
            String nonGraphProperties = view.getProperty(SchemaView.nonGraphProperties);
            if (nonGraphProperties == null) continue;
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList(nonGraphProperties.split("[, ]+")));
            int pos = properties.indexOf(toRemove);
            if (pos != -1) {
                properties.set(pos, newValue);
            }
            view.setProperty(SchemaView.nonGraphProperties, StringUtils.join(properties, (String)", "));
        }
    }

    private void removeNameFromNonGraphProperties(AbstractSchemaNode schemaNode, String toRemove) throws FrameworkException {
        for (SchemaView view : schemaNode.getSchemaViews()) {
            String nonGraphProperties = view.getProperty(SchemaView.nonGraphProperties);
            if (nonGraphProperties == null) continue;
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList(nonGraphProperties.split("[, ]+")));
            properties.remove(toRemove);
            view.setProperty(SchemaView.nonGraphProperties, StringUtils.join(properties, (String)", "));
        }
    }

    public static String getDefaultRelationshipType(SchemaRelationshipNode rel) {
        return SchemaRelationshipNode.getDefaultRelationshipType(rel.getSourceNode(), rel.getTargetNode());
    }

    public static String getDefaultRelationshipType(SchemaNode sourceNode, SchemaNode targetNode) {
        return SchemaRelationshipNode.getDefaultRelationshipType(sourceNode.getName(), targetNode.getName());
    }

    public static String getDefaultRelationshipType(String sourceType, String targetType) {
        return sourceType + "_" + targetType;
    }

    private static class KeyMatcher
    implements Predicate<String> {
        private KeyMatcher() {
        }

        public boolean accept(String t) {
            if (ValidKeyPattern.matcher(t).matches()) {
                return true;
            }
            logger.warn("Invalid key name {} for notion.", (Object)t);
            return false;
        }
    }

    public static enum Direction {
        None,
        In,
        Out,
        Both;

    }

    public static enum Propagation {
        Add,
        Keep,
        Remove;

    }
}

