/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.TransactionCommand;
import org.structr.schema.ReloadSchema;
import org.structr.schema.SchemaHelper;

public abstract class SchemaReloadingNode
extends AbstractNode {
    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
            return true;
        }
        return false;
    }

    @Override
    public void onNodeDeletion() {
        String signature = this.getResourceSignature();
        if (StringUtils.isNotBlank((CharSequence)signature)) {
            SchemaHelper.removeDynamicGrants(this.getResourceSignature());
        }
        TransactionCommand.postProcess("reloadSchema", new ReloadSchema());
    }

    public String getResourceSignature() {
        return (String)this.getProperty(name);
    }

    public String getClassName() {
        return (String)this.getProperty(name);
    }

    public String getSuperclassName() {
        String superclassName = this.getProperty(SchemaNode.extendsClass);
        if (superclassName == null) {
            return AbstractNode.class.getSimpleName();
        }
        return superclassName.substring(superclassName.lastIndexOf(".") + 1);
    }
}

