/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.LinkedHashSet;
import java.util.Set;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.SecurityDelegate;
import org.structr.common.View;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.ManyToMany;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.ArrayProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.SourceId;
import org.structr.core.property.TargetId;

public class Security
extends ManyToMany<Principal, NodeInterface> {
    public static final SourceId principalId = new SourceId("principalId");
    public static final TargetId accessControllableId = new TargetId("accessControllableId");
    public static final Property<String[]> allowed = new ArrayProperty<String>("allowed", String.class);
    public static final View uiView = new View(Security.class, "ui", allowed);

    public Security() {
    }

    public Security(SecurityContext securityContext, Relationship dbRelationship) {
        this.init(securityContext, dbRelationship, Security.class);
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedHashSet<PropertyKey> keys = new LinkedHashSet<PropertyKey>();
        keys.addAll((Set)super.getPropertyKeys(propertyView));
        keys.add(principalId);
        keys.add(accessControllableId);
        if (this.dbRelationship != null) {
            for (String key : this.dbRelationship.getPropertyKeys()) {
                keys.add(StructrApp.getConfiguration().getPropertyKeyForDatabaseName(this.entityType, key));
            }
        }
        return keys;
    }

    public boolean isAllowed(Permission permission) {
        return SecurityDelegate.getPermissionSet((PropertyContainer)this.dbRelationship, allowed).contains(permission.name());
    }

    public void setAllowed(Set<String> allowed) {
        SecurityDelegate.setAllowed((GraphObject)this, Security.allowed, allowed);
    }

    public void setAllowed(Permission ... allowed) {
        SecurityDelegate.setAllowed((GraphObject)this, Security.allowed, allowed);
    }

    public Set<String> getPermissions() {
        return SecurityDelegate.getPermissions(this, allowed);
    }

    public void addPermission(Permission permission) {
        SecurityDelegate.addPermission(this, allowed, permission);
    }

    public void removePermission(Permission permission) {
        SecurityDelegate.removePermission(this, allowed, permission);
    }

    @Override
    public Class<Principal> getSourceType() {
        return Principal.class;
    }

    public String name() {
        return "SECURITY";
    }

    @Override
    public Class<NodeInterface> getTargetType() {
        return NodeInterface.class;
    }

    @Override
    public Property<String> getSourceIdProperty() {
        return principalId;
    }

    @Override
    public Property<String> getTargetIdProperty() {
        return accessControllableId;
    }

    @Override
    public boolean isInternal() {
        return true;
    }
}

