/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class AbbrFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ABBR = "Usage: ${abbr(longString, maxLength)}. Example: ${abbr(this.title, 20)}";

    @Override
    public String getName() {
        return "abbr()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (sources == null || sources.length != 2 || sources[1] == null) {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                return this.usage(ctx.isJavaScriptContext());
            }
            if (sources[0] == null) {
                return "";
            }
            int maxLength = Double.valueOf(sources[1].toString()).intValue();
            if (sources[0].toString().length() > maxLength) {
                return StringUtils.substringBeforeLast((String)StringUtils.substring((String)sources[0].toString(), (int)0, (int)maxLength), (String)" ").concat("\u2026");
            }
            return sources[0];
        }
        catch (NumberFormatException nfe) {
            this.logException(nfe, "{}: NumberFormatException in \"{}\". Can not parse \"{}\" as Integer. Returning original string. Parameters: {}", new Object[]{this.getName(), caller, sources[1], this.getParametersAsString(sources)});
            return sources[0];
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_ABBR;
    }

    @Override
    public String shortDescription() {
        return "Abbreviates the given string";
    }
}

