/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class AndFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_AND = "Usage: ${and(bool1, bool2)}. Example: ${and(\"true\", \"true\")}";

    @Override
    public String getName() {
        return "and()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        boolean result = true;
        if (sources != null) {
            for (Object i : sources) {
                if (i != null) {
                    try {
                        result &= "true".equals(i.toString()) || Boolean.TRUE.equals(i);
                        continue;
                    }
                    catch (Throwable t) {
                        this.logException(caller, t, sources);
                        return t.getMessage();
                    }
                }
                return false;
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            result = false;
        }
        return result;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_AND;
    }

    @Override
    public String shortDescription() {
        return "Returns the conjunction of the given arguments";
    }
}

