/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class AppendFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_APPEND = "Usage: ${append(filename, value)}. Example: ${append(\"test.txt\", this.name)}";

    @Override
    public String getName() {
        return "append()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        block17: {
            if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
                try {
                    String sandboxFilename = this.getSandboxFileName(sources[0].toString());
                    if (sandboxFilename == null) break block17;
                    File file = new File(sandboxFilename);
                    try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file, true));){
                        for (int i = 1; i < sources.length; ++i) {
                            IOUtils.write((String)sources[i].toString(), (Writer)writer);
                        }
                        ((Writer)writer).flush();
                    }
                }
                catch (IOException ioex) {
                    this.logException(caller, ioex, sources);
                }
            } else {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            }
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_APPEND;
    }

    @Override
    public String shortDescription() {
        return "Appends to the given file in the exchange directoy";
    }
}

