/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObjectMap;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Actions;
import org.structr.schema.action.Function;

public class CallFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CALL = "Usage: ${call(key [, key, value]}. Example ${call('myEvent', 'key1', 'value1', 'key2', 'value2')}";
    public static final String ERROR_MESSAGE_CALL_JS = "Usage: ${{Structr.call(key [, parameterMap]}}. Example ${{Structr.call('myEvent', {key1: 'value1', key2: 'value2'})}}";

    @Override
    public String getName() {
        return "call()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null && sources.length >= 1 && sources[0] != null) {
            try {
                String methodName = sources[0].toString();
                if (sources.length == 1) {
                    return Actions.callWithSecurityContext(methodName, this.getSecurityContext(ctx), Collections.EMPTY_MAP);
                }
                if (sources.length == 2 && sources[1] instanceof Map) {
                    return Actions.callWithSecurityContext(methodName, this.getSecurityContext(ctx), (Map)sources[1]);
                }
                if (sources.length == 2 && sources[1] instanceof GraphObjectMap) {
                    return Actions.callWithSecurityContext(methodName, this.getSecurityContext(ctx), ((GraphObjectMap)sources[1]).toMap());
                }
                int parameter_count = sources.length;
                if (parameter_count % 2 == 0) {
                    throw new FrameworkException(400, "Invalid number of parameters: " + parameter_count + ". Should be uneven: " + this.usage(ctx.isJavaScriptContext()));
                }
                LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                for (int c = 1; c < parameter_count; c += 2) {
                    newMap.put(sources[c].toString(), sources[c + 1]);
                }
                return Actions.callWithSecurityContext(methodName, this.getSecurityContext(ctx), newMap);
            }
            catch (UnlicensedException ex) {
                ex.printStackTrace();
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_CALL_JS : ERROR_MESSAGE_CALL;
    }

    @Override
    public String shortDescription() {
        return "Calls the given global schema method in the current users context";
    }

    public SecurityContext getSecurityContext(ActionContext ctx) {
        return ctx.getSecurityContext();
    }
}

