/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CeilFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CEIL = "Usage: ${ceil(value)}. Example: ${ceil(32.4)}";

    @Override
    public String getName() {
        return "ceil()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return (int)Math.ceil(Double.parseDouble(sources[0].toString()));
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_CEIL;
    }

    @Override
    public String shortDescription() {
        return "Returns the smallest integer that is greater than or equal to the argument";
    }
}

