/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ConcatFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CONCAT = "Usage: ${concat(values...)}. Example: ${concat(this.firstName, this.lastName)}";

    @Override
    public String getName() {
        return "concat()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            for (Object source : sources) {
                if (source == null) continue;
                if (source instanceof Collection) {
                    list.addAll((Collection)source);
                    continue;
                }
                if (source.getClass().isArray()) {
                    list.addAll(Arrays.asList((Object[])source));
                    continue;
                }
                list.add(source);
            }
            return StringUtils.join(list, (String)"");
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_CONCAT;
    }

    @Override
    public String shortDescription() {
        return "Concatenates all its parameters to a single string with the given separator";
    }
}

