/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractUser;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ConfigFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CONFIG = "Usage: ${config(keyFromStructrConf[, \"default\"])}. Example: ${config(\"base.path\")}";
    public static final String ERROR_MESSAGE_CONFIG_JS = "Usage: ${{Structr.config(keyFromStructrConf[, \"default\"])}}. Example: ${{Structr.config(\"base.path\")}}";

    @Override
    public String getName() {
        return "config()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
                return null;
            }
            String configKey = sources[0].toString();
            if (Settings.SuperUserPassword.getKey().equals(configKey)) {
                return AbstractUser.HIDDEN;
            }
            String defaultValue = sources.length >= 2 ? sources[1].toString() : "";
            Setting setting = Settings.getSetting((String[])new String[]{configKey});
            if (setting != null) {
                return setting.getValue();
            }
            return defaultValue;
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_CONFIG_JS : ERROR_MESSAGE_CONFIG;
    }

    @Override
    public String shortDescription() {
        return "Returns the structr.conf value with the given key";
    }
}

