/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ContainsFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CONTAINS = "Usage: ${contains(string, word)} or ${contains(collection, element)}. Example: ${contains(this.name, \"the\")} or ${contains(find('Page'), page)}";

    @Override
    public String getName() {
        return "contains()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return false;
            }
            if (sources[0] instanceof String && sources[1] instanceof String) {
                String source = sources[0].toString();
                String part = sources[1].toString();
                return source.contains(part);
            }
            if (sources[0] instanceof Collection) {
                Collection collection = (Collection)sources[0];
                return collection.contains(sources[1]);
            }
            if (sources[0].getClass().isArray()) {
                return ArrayUtils.contains((Object[])((Object[])sources[0]), (Object)sources[1]);
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return false;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_CONTAINS;
    }

    @Override
    public String shortDescription() {
        return "Returns true if the given string or collection contains an element";
    }
}

