/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.Permissions;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Security;
import org.structr.core.graph.NodeInterface;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CopyPermissionsFunction
extends Function<Object, Object> {
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
            Object source = sources[0];
            Object target = sources[1];
            if (source instanceof NodeInterface && target instanceof NodeInterface) {
                NodeInterface sourceNode = (NodeInterface)source;
                NodeInterface targetNode = (NodeInterface)target;
                for (Security security : sourceNode.getIncomingRelationships(Security.class)) {
                    Principal principal = (Principal)security.getSourceNode();
                    for (String perm : security.getPermissions()) {
                        targetNode.grant(Permissions.valueOf(perm), principal);
                    }
                }
            } else {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            }
        } else {
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        if (inJavaScriptContext) {
            return "Usage: Structr.copyPermissions(Structr.this, other);";
        }
        return "Usage: copy_permissions(this, this.child)";
    }

    @Override
    public String shortDescription() {
        return "Copies the security configuration of an entity to another entity.";
    }

    @Override
    public String getName() {
        return "copy_permissions()";
    }
}

