/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.LinkedHashMap;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CypherFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CYPHER = "Usage: ${cypher(query)}. Example ${cypher('MATCH (n) RETURN n')}";
    public static final String ERROR_MESSAGE_CYPHER_JS = "Usage: ${{Structr.cypher(query)}}. Example ${{Structr.cypher('MATCH (n) RETURN n')}}";

    @Override
    public String getName() {
        return "cypher()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String query = sources[0].toString();
            if (sources.length > 1 && sources[1] != null && sources[1] instanceof Map) {
                params.putAll((Map)sources[1]);
            }
            return StructrApp.getInstance(ctx.getSecurityContext()).cypher(query, params);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_CYPHER_JS : ERROR_MESSAGE_CYPHER;
    }

    @Override
    public String shortDescription() {
        return "Returns the result of the given Cypher query";
    }
}

