/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.function.BatchableFunction;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.Tx;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class DeleteFunction
extends Function<Object, Object>
implements BatchableFunction {
    private static final Logger logger = LoggerFactory.getLogger(DeleteFunction.class);
    public static final String ERROR_MESSAGE_DELETE = "Usage: ${delete(entityOrCollection)}. Example: ${delete(this)}";
    private boolean batched = false;
    private int batchSize = -1;

    @Override
    public String getName() {
        return "delete()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null) {
            App app = StructrApp.getInstance(ctx.getSecurityContext());
            for (Object obj : sources) {
                this.deleteObject(app, obj);
            }
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_DELETE;
    }

    @Override
    public String shortDescription() {
        return "Deletes the given entity from the database";
    }

    @Override
    public void setBatched(boolean isBatched) {
        this.batched = isBatched;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private void deleteObject(App app, Object obj) throws FrameworkException {
        block20: {
            if (obj instanceof NodeInterface) {
                app.delete((NodeInterface)obj);
            }
            if (obj instanceof RelationshipInterface) {
                app.delete((RelationshipInterface)obj);
            }
            if (!(obj instanceof Iterable)) break block20;
            if (this.batched) {
                Iterable iterable = (Iterable)obj;
                Iterator iterator = iterable.iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    try (Tx tx = app.tx();){
                        while (iterator.hasNext()) {
                            this.deleteObject(app, iterator.next());
                            if (++count % this.batchSize != 0) continue;
                        }
                        tx.success();
                    }
                    logger.info("Commiting batch after {} objects", (Object)count);
                    count = 0;
                }
            } else {
                for (Object o : (Iterable)obj) {
                    this.deleteObject(app, o);
                }
            }
        }
    }
}

