/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class DoubleSumFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_DOUBLE_SUM = "Usage: ${double_sum(list)}. Example: ${double_sum(extract(this.children, \"amount\"))}";

    @Override
    public String getName() {
        return "double_sum()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        double result = 0.0;
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (sources[0] instanceof Collection) {
                for (Number num : (Collection)sources[0]) {
                    result += num.doubleValue();
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return result;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_DOUBLE_SUM;
    }

    @Override
    public String shortDescription() {
        return "Returns the sum of the given arguments as a floating-point number";
    }
}

