/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.common.error.SemanticErrorToken;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ErrorFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ERROR = "Usage: ${error(...)}. Example: ${error(\"base\", \"must_equal\", int(5))}";

    @Override
    public String getName() {
        return "error()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        Class<?> entityType = null;
        String type = null;
        if (caller != null && caller instanceof GraphObject) {
            entityType = caller.getClass();
            type = ((GraphObject)caller).getType();
        }
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            switch (sources.length) {
                case 1: {
                    throw new IllegalArgumentException();
                }
                case 2: {
                    this.arrayHasLengthAndAllElementsNotNull(sources, 2);
                    PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(entityType, sources[0].toString());
                    ctx.raiseError(422, new SemanticErrorToken(type, key, sources[1].toString()));
                    break;
                }
                case 3: {
                    this.arrayHasLengthAndAllElementsNotNull(sources, 3);
                    PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(entityType, sources[0].toString());
                    ctx.raiseError(422, new SemanticErrorToken(type, key, sources[1].toString(), sources[2]));
                    break;
                }
                default: {
                    this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_ERROR;
    }

    @Override
    public String shortDescription() {
        return "Signals an error to the caller";
    }
}

