/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.StringEscapeUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class EscapeJsonFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ESCAPE_JSON = "Usage: ${escape_json(string)}. Example: ${escape_json(this.name)}";

    @Override
    public String getName() {
        return "escape_json()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return StringEscapeUtils.escapeJson((String)sources[0].toString());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_ESCAPE_JSON;
    }

    @Override
    public String shortDescription() {
        return "Escapes the given string for use within JSON";
    }
}

