/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class EvaluateScriptFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)EvaluateScriptFunction.class.getName());
    public static final String ERROR_MESSAGE_EVALUATE_SCRIPT = "Usage: ${evaluate_script(entity, script)}";
    public static final String ERROR_MESSAGE_EVALUATE_SCRIPT_JS = "Usage: ${Structr.evaluate_script(entity, script)}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null && sources.length == 2 && sources[1] != null && sources[1] instanceof String && sources[0] != null && sources[0] instanceof GraphObject) {
            String script = "${" + sources[1] + "}";
            GraphObject entity = (GraphObject)sources[0];
            return Scripting.replaceVariables(ctx, entity, script);
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_EVALUATE_SCRIPT_JS : ERROR_MESSAGE_EVALUATE_SCRIPT;
    }

    @Override
    public String shortDescription() {
        return "Evaluates script given as string in the context of given parameters.";
    }

    @Override
    public String getName() {
        return "evaluate_script()";
    }
}

