/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class FirstFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_FIRST = "Usage: ${first(collection)}. Example: ${first(this.children)}";

    @Override
    public String getName() {
        return "first()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            Object[] arr;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (sources[0] instanceof List && !((List)sources[0]).isEmpty()) {
                return ((List)sources[0]).get(0);
            }
            if (sources[0].getClass().isArray() && (arr = (Object[])sources[0]).length > 0) {
                return arr[0];
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_FIRST;
    }

    @Override
    public String shortDescription() {
        return "Returns the first element of the given collection";
    }
}

