/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class FloorFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_FLOOR = "Usage: ${floor(value)}. Example: ${floor(32.4)}";

    @Override
    public String getName() {
        return "floor()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return (int)Math.floor(Double.parseDouble(sources[0].toString()));
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_FLOOR;
    }

    @Override
    public String shortDescription() {
        return "Returns the largest integer that is less than or equal to the argument";
    }
}

