/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.LinkedHashMap;
import org.structr.common.error.FrameworkException;
import org.structr.common.geo.AddressComponent;
import org.structr.common.geo.GeoCodingResult;
import org.structr.common.geo.GeoHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GeocodeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GEOCODE = "Usage: ${geocode(street, city, country)}. Example: ${set(this, geocode(this.street, this.city, this.country))}";

    @Override
    public String getName() {
        return "geocode()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            String country;
            String city;
            String street;
            GeoCodingResult result;
            if (this.arrayHasLengthAndAllElementsNotNull(sources, 3) && (result = GeoHelper.geocode(street = sources[0].toString(), null, null, city = sources[1].toString(), null, country = sources[2].toString())) != null) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("latitude", result.getLatitude());
                map.put("longitude", result.getLongitude());
                AddressComponent cur = null;
                cur = result.getAddressComponent(GeoCodingResult.Type.country);
                if (cur != null) {
                    map.put("country", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.postal_code)) != null) {
                    map.put("postalCode", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.locality)) != null) {
                    map.put("city", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.route)) != null) {
                    map.put("street", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.street_number)) != null) {
                    map.put("houseNumber", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.administrative_area_level_1)) != null) {
                    map.put("state", cur.getValue());
                }
                if ((cur = result.getAddressComponent(GeoCodingResult.Type.administrative_area_level_3)) != null) {
                    map.put("stateDistrict", cur.getValue());
                }
                return map;
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_GEOCODE;
    }

    @Override
    public String shortDescription() {
        return "Returns the geolocation (latitude, longitude) for the given street address using the configured geocoding provider";
    }
}

