/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetCounterFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET_COUNTER = "Usage: ${get_counter(level)}. Example: ${get_counter(1)}";

    @Override
    public String getName() {
        return "get_counter()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return 0;
            }
            try {
                return ctx.getCounter(this.parseInt(sources[0]));
            }
            catch (NumberFormatException nfe) {
                this.logException(nfe, "{}: NumberFormatException parsing counter level \"{}\" in element \"{}\". Parameters: {}", new Object[]{this.getName(), sources[0].toString(), caller, this.getParametersAsString(sources)});
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return 0;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_GET_COUNTER;
    }

    @Override
    public String shortDescription() {
        return "Returns the value of the counter with the given index";
    }
}

