/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetIncomingRelationshipsFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET_INCOMING_RELATIONSHIPS = "Usage: ${get_incoming_relationships(from, to [, relType])}. Example: ${get_incoming_relationships(me, user, 'FOLLOWS')}";
    public static final String ERROR_MESSAGE_GET_INCOMING_RELATIONSHIPS_JS = "Usage: ${{Structr.get_incoming_relationships(from, to [, relType])}}. Example: ${{Structr.get_incoming_relationships(Structr.get('me'), user, 'FOLLOWS')}}";

    @Override
    public String getName() {
        return "get_incoming_relationships()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ArrayList<AbstractRelationship> list = new ArrayList<AbstractRelationship>();
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
            Object source = sources[0];
            Object target = sources[1];
            AbstractNode sourceNode = null;
            AbstractNode targetNode = null;
            if (!(source instanceof AbstractNode) || !(target instanceof AbstractNode)) {
                logger.warn("Error: entities are not nodes. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: entities are not nodes.";
            }
            sourceNode = (AbstractNode)source;
            targetNode = (AbstractNode)target;
            if (sources.length == 2) {
                for (AbstractRelationship rel : sourceNode.getIncomingRelationships()) {
                    Object s = rel.getSourceNode();
                    Object t = rel.getTargetNode();
                    if (s == null || t == null || !s.equals(targetNode) || !t.equals(sourceNode)) continue;
                    list.add(rel);
                }
            } else if (sources.length == 3) {
                String relType = (String)sources[2];
                for (AbstractRelationship rel : sourceNode.getIncomingRelationships()) {
                    Object s = rel.getSourceNode();
                    Object t = rel.getTargetNode();
                    if (s == null || t == null || !rel.getRelType().name().equals(relType) || !s.equals(targetNode) || !t.equals(sourceNode)) continue;
                    list.add(rel);
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return list;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_GET_INCOMING_RELATIONSHIPS_JS : ERROR_MESSAGE_GET_INCOMING_RELATIONSHIPS;
    }

    @Override
    public String shortDescription() {
        return "Returns the incoming relationships of the given entity with an optional relationship type";
    }
}

