/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetOrCreateFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET_OR_CREATE = "Usage: ${get_or_create(type, properties)}. Example: ${get_or_create(\"User\", \"email\", \"tester@test.com\"}";
    public static final String ERROR_MESSAGE_NO_TYPE_SPECIFIED = "Error in get_or_create(): no type specified.";
    public static final String ERROR_MESSAGE_TYPE_NOT_FOUND = "Error in get_or_create(): type not found: ";

    @Override
    public String getName() {
        return "get_or_create()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            String typeString;
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            SecurityContext securityContext = ctx.getSecurityContext();
            ConfigurationProvider config = StructrApp.getConfiguration();
            App app = StructrApp.getInstance(securityContext);
            PropertyMap properties = new PropertyMap();
            Class type = null;
            if (sources.length >= 1 && sources[0] != null && (type = config.getNodeEntityClass(typeString = sources[0].toString())) == null) {
                logger.warn("Error in get_or_create(): type \"{}\" not found.", (Object)typeString);
                return ERROR_MESSAGE_TYPE_NOT_FOUND + typeString;
            }
            if (type == null) {
                logger.warn("Error in get_or_create(): no type specified. Parameters: {}", (Object)this.getParametersAsString(sources));
                return ERROR_MESSAGE_NO_TYPE_SPECIFIED;
            }
            securityContext.ignoreResultCount(true);
            if (sources.length == 2 && sources[1] instanceof Map) {
                properties.putAll(PropertyMap.inputTypeToJavaType(securityContext, type, (Map)sources[1]));
            } else {
                int parameter_count = sources.length;
                if (parameter_count % 2 == 0) {
                    throw new FrameworkException(400, "Invalid number of parameters: " + parameter_count + ". Should be uneven: " + ERROR_MESSAGE_GET_OR_CREATE);
                }
                for (int c = 1; c < parameter_count; c += 2) {
                    if (sources[c] == null) {
                        throw new IllegalArgumentException();
                    }
                    PropertyKey key = config.getPropertyKeyForJSONName(type, sources[c].toString());
                    if (key == null) continue;
                    PropertyConverter inputConverter = key.inputConverter(securityContext);
                    Object value = sources[c + 1];
                    if (inputConverter != null) {
                        value = inputConverter.convert(value);
                    }
                    properties.put(key, value);
                }
            }
            Object obj = app.nodeQuery(type).sort(GraphObject.createdDate).order(false).and(properties).getFirst();
            if (obj != null) {
                return obj;
            }
            return app.create(type, properties);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_GET_OR_CREATE;
    }

    @Override
    public String shortDescription() {
        return "Returns an entity with the given properties, creating one if it doesn't exist.";
    }
}

