/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetOrNullFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET_OR_NULL = "Usage: ${get_or_null(entity, propertyKey)}. Example: ${get_or_null(this, \"children\")}";
    public static final String ERROR_MESSAGE_GET_OR_NULL_JS = "Usage: ${{Structr.getOrNull(entity, propertyKey)}}. Example: ${{Structr.getOrNull(this, \"children\")}}";

    @Override
    public String getName() {
        return "get_or_null()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        SecurityContext securityContext = ctx.getSecurityContext();
        try {
            List list;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return null;
            }
            GraphObject dataObject = null;
            if (sources[0] instanceof GraphObject) {
                dataObject = (GraphObject)sources[0];
            }
            if (sources[0] instanceof List && (list = (List)sources[0]).size() == 1 && list.get(0) instanceof GraphObject) {
                dataObject = (GraphObject)list.get(0);
            }
            if (dataObject != null) {
                String keyName = sources[1].toString();
                PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(dataObject.getClass(), keyName);
                if (key != null) {
                    PropertyConverter inputConverter = key.inputConverter(securityContext);
                    Object value = dataObject.getProperty(key);
                    if (inputConverter != null) {
                        return inputConverter.revert(value);
                    }
                    return dataObject.getProperty(key);
                }
                return "";
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        if (inJavaScriptContext) {
            return ERROR_MESSAGE_GET_OR_NULL_JS;
        }
        return ERROR_MESSAGE_GET_OR_NULL;
    }

    @Override
    public String shortDescription() {
        return "Returns the value with the given name of the given entity, or null";
    }
}

