/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetRelationshipsFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET_RELATIONSHIPS = "Usage: ${get_relationships(entity1, entity2 [, relType])}. Example: ${get_relationships(me, user, 'FOLLOWS')}  (ignores direction of the relationship)";
    public static final String ERROR_MESSAGE_GET_RELATIONSHIPS_JS = "Usage: ${{Structr.get_relationships(entity1, entity2 [, relType])}}. Example: ${{Structr.get_relationships(Structr.get('me'), user, 'FOLLOWS')}}  (ignores direction of the relationship)";

    @Override
    public String getName() {
        return "get_relationships()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ArrayList<AbstractRelationship> list = new ArrayList<AbstractRelationship>();
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
            Object source = sources[0];
            Object target = sources[1];
            NodeInterface sourceNode = null;
            NodeInterface targetNode = null;
            if (!(source instanceof NodeInterface) || !(target instanceof NodeInterface)) {
                logger.warn("Error: entities are not nodes. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: Entities are not nodes.";
            }
            sourceNode = (NodeInterface)source;
            targetNode = (NodeInterface)target;
            if (sources.length == 2) {
                for (AbstractRelationship rel : sourceNode.getRelationships()) {
                    Object s = rel.getSourceNode();
                    Object t = rel.getTargetNode();
                    if (s == null || t == null || (!s.equals(sourceNode) || !t.equals(targetNode)) && (!s.equals(targetNode) || !t.equals(sourceNode))) continue;
                    list.add(rel);
                }
            } else if (sources.length == 3) {
                String relType = (String)sources[2];
                for (AbstractRelationship rel : sourceNode.getRelationships()) {
                    Object s = rel.getSourceNode();
                    Object t = rel.getTargetNode();
                    if (s == null || t == null || !rel.getRelType().name().equals(relType) || (!s.equals(sourceNode) || !t.equals(targetNode)) && (!s.equals(targetNode) || !t.equals(sourceNode))) continue;
                    list.add(rel);
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return list;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_GET_RELATIONSHIPS_JS : ERROR_MESSAGE_GET_RELATIONSHIPS;
    }

    @Override
    public String shortDescription() {
        return "Returns the relationships of the given entity with an optional relationship type";
    }
}

