/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class IncCounterFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INC_COUNTER = "Usage: ${inc_counter(level[, resetLowerLevels])}. Example: ${inc_counter(1, true)}";

    @Override
    public String getName() {
        return "inc_counter()";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
            try {
                int level = this.parseInt(sources[0]);
                ctx.incrementCounter(level);
                if (sources.length != 2 || !"true".equals(sources[1].toString())) return "";
                for (int i = level + 1; i < 10; ++i) {
                    ctx.resetCounter(i);
                }
                return "";
            }
            catch (NumberFormatException nfe) {
                this.logException(nfe, "{}: NumberFormatException parsing counter level \"{}\" in element \"{}\". Parameters: {}", new Object[]{this.getName(), sources[0].toString(), caller, this.getParametersAsString(sources)});
                return "";
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_INC_COUNTER;
    }

    @Override
    public String shortDescription() {
        return "Increases the value of the counter with the given index";
    }
}

