/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class IndexOfFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INDEX_OF = "Usage: ${index_of(string, word)}. Example: ${index_of(this.name, \"the\")}";

    @Override
    public String getName() {
        return "index_of()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return "";
            }
            String source = sources[0].toString();
            String part = sources[1].toString();
            return source.indexOf(part);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_INDEX_OF;
    }

    @Override
    public String shortDescription() {
        return "Returns the position of string in a string, or -1";
    }
}

