/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.search.SearchCommand;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class InheritingTypesFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INHERITING_TYPES = "Usage: ${inheriting_types(type[, blacklist])}. Example ${inheriting_types('User')}";
    public static final String ERROR_MESSAGE_INHERITING_TYPES_JS = "Usage: ${Structr.inheriting_types(type[, blacklist])}. Example ${Structr.inheriting_types('User')}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
                String typeName = sources[0].toString();
                Class type = SchemaHelper.getEntityClassForRawType(typeName);
                ArrayList<String> inheritants = new ArrayList<String>();
                inheritants.addAll(SearchCommand.getAllSubtypesAsStringSet(type.getSimpleName()));
                if (sources.length == 2) {
                    inheritants.removeAll((List)sources[1]);
                }
                return inheritants;
            }
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_INHERITING_TYPES_JS : ERROR_MESSAGE_INHERITING_TYPES;
    }

    @Override
    public String shortDescription() {
        return "Returns the names of the child classes of the given type";
    }

    @Override
    public String getName() {
        return "inheriting_types()";
    }
}

