/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.api.graph.Node;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeFactory;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class InstantiateFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INSTANTIATE = "Usage: ${instantiate(node)}. Example: ${instantiate(result.node)}";

    @Override
    public String getName() {
        return "instantiate()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (!(sources[0] instanceof Node)) {
                throw new IllegalArgumentException();
            }
            return new NodeFactory(ctx.getSecurityContext()).instantiate((Node)sources[0]);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_INSTANTIATE;
    }

    @Override
    public String shortDescription() {
        return "Instantiates the given Neo4j nodes into Structr nodes";
    }
}

