/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class IntFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INT = "Usage: ${int(string)}. Example: ${int(this.numericalStringValue)}";

    @Override
    public String getName() {
        return "int()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (sources[0] instanceof Number) {
                return ((Number)sources[0]).intValue();
            }
            try {
                return this.getDoubleOrNull(sources[0]).intValue();
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_INT;
    }

    @Override
    public String shortDescription() {
        return "Converts the given string to an integer";
    }
}

