/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class JoinFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_JOIN = "Usage: ${join(collection, separator)}. Example: ${join(this.names, \",\")}";

    @Override
    public String getName() {
        return "join()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return "";
            }
            if (sources[0] instanceof Collection) {
                return StringUtils.join((Iterable)((Collection)sources[0]), (String)sources[1].toString());
            }
            if (sources[0].getClass().isArray()) {
                return StringUtils.join((Object[])((Object[])sources[0]), (String)sources[1].toString());
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_JOIN;
    }

    @Override
    public String shortDescription() {
        return "Joins all its parameters to a single string";
    }
}

