/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.structr.api.util.FixedSizeCache;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Localization;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class LocalizeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_LOCALIZE = "Usage: ${localize(key[, domain])}. Example ${localize('HELLO_WORLD', 'myDomain')}";
    public static final String ERROR_MESSAGE_LOCALIZE_JS = "Usage: ${{Structr.localize(key[, domain])}}. Example ${{Structr.localize('HELLO_WORLD', 'myDomain')}}";
    private static final FixedSizeCache<String, String> localizationCache = new FixedSizeCache(10000);

    @Override
    public String getName() {
        return "localize()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        Locale ctxLocale = ctx.getLocale();
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
            if (sources[0] instanceof List) {
                List keyList = (List)sources[0];
                if (sources.length == 1) {
                    return LocalizeFunction.getLocalizedList(ctxLocale, keyList);
                }
                return LocalizeFunction.getLocalizedList(ctxLocale, keyList, sources[1].toString());
            }
            String name = sources[0].toString();
            if (sources.length == 1) {
                return LocalizeFunction.getLocalization(ctxLocale, name);
            }
            return LocalizeFunction.getLocalization(ctxLocale, name, sources[1].toString());
        }
        if (sources.length == 1 || sources.length == 2) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return "";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_LOCALIZE_JS : ERROR_MESSAGE_LOCALIZE;
    }

    @Override
    public String shortDescription() {
        return "";
    }

    public static List getLocalizedList(Locale locale, List<String> keyList) throws FrameworkException {
        return LocalizeFunction.getLocalizedList(locale, keyList, null);
    }

    public static List getLocalizedList(Locale locale, List<String> keyList, String domain) throws FrameworkException {
        ArrayList<GraphObjectMap> resultList = new ArrayList<GraphObjectMap>();
        for (String key : keyList) {
            GraphObjectMap localizedEntry = new GraphObjectMap();
            resultList.add(localizedEntry);
            localizedEntry.put((PropertyKey)new StringProperty("name"), key);
            if (domain == null) {
                localizedEntry.put((PropertyKey)new StringProperty("localizedName"), LocalizeFunction.getLocalization(locale, key));
                continue;
            }
            localizedEntry.put((PropertyKey)new StringProperty("localizedName"), LocalizeFunction.getLocalization(locale, key, domain));
        }
        return resultList;
    }

    public static String getLocalization(Locale locale, String key) throws FrameworkException {
        return LocalizeFunction.getLocalization(locale, key, null);
    }

    public static String getLocalization(Locale locale, String requestedKey, String requestedDomain) throws FrameworkException {
        String fullLocale = locale.toString();
        String lang = locale.getLanguage();
        String cacheKey = LocalizeFunction.cacheKey(fullLocale, requestedKey, requestedDomain);
        String finalDomain = requestedDomain == null ? "" : requestedDomain;
        String value = LocalizeFunction.getCachedValue(cacheKey);
        if (value == null) {
            value = LocalizeFunction.getLocalizedNameFromDatabase(requestedKey, finalDomain, fullLocale);
        }
        if (value == null && !finalDomain.equals("")) {
            value = LocalizeFunction.getLocalizedNameFromDatabase(requestedKey, "", fullLocale);
        }
        if (value == null) {
            value = LocalizeFunction.getLocalizedNameFromDatabase(requestedKey, finalDomain, lang);
        }
        if (value == null && !finalDomain.equals("")) {
            value = LocalizeFunction.getLocalizedNameFromDatabase(requestedKey, "", lang);
        }
        if (value == null) {
            value = requestedKey;
        } else {
            LocalizeFunction.cacheValue(cacheKey, value);
        }
        return value;
    }

    public static synchronized void invalidateCache() {
        localizationCache.clear();
    }

    private static String cacheKey(String locale, String key, String domain) {
        StringBuilder buf = new StringBuilder(locale);
        buf.append("||").append(key);
        if (domain != null && !domain.equals("")) {
            buf.append("||").append(domain);
        }
        return buf.toString();
    }

    private static synchronized String getCachedValue(String cacheKey) {
        return (String)localizationCache.get((Object)cacheKey);
    }

    private static synchronized void cacheValue(String cacheKey, String value) {
        localizationCache.put((Object)cacheKey, (Object)value);
    }

    private static String getLocalizedNameFromDatabase(String key, String domain, String locale) throws FrameworkException {
        List<Localization> localizations = StructrApp.getInstance().nodeQuery(Localization.class).and(Localization.name, key).and(Localization.domain, domain).and(Localization.locale, locale).getAsList();
        if (localizations.isEmpty()) {
            return null;
        }
        if (localizations.size() > 1) {
            logger.warn("Found ambiguous localization for locale \"{}\", key \"{}\" and domain \"{}\". Please fix. Parameters: {}", new Object[]{locale, key, domain});
        }
        return localizations.get(0).getProperty(Localization.localizedName);
    }
}

