/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class LogFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)LogFunction.class.getName());
    public static final String ERROR_MESSAGE_LOG = "Usage: ${log(string)}. Example ${log('Hello World!')}";
    public static final String ERROR_MESSAGE_LOG_JS = "Usage: ${{Structr.log(string)}}. Example ${{Structr.log('Hello World!')}}";

    @Override
    public String getName() {
        return "log()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            StringBuilder buf = new StringBuilder();
            for (Object obj : sources) {
                if (obj == null) continue;
                buf.append(Scripting.formatToDefaultDateOrString(obj));
            }
            logger.info(buf.toString());
            return "";
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_LOG_JS : ERROR_MESSAGE_LOG;
    }

    @Override
    public String shortDescription() {
        return "Logs the given string to the logfile";
    }
}

