/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ModFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MODULO = "Usage: ${mod(value1, value2)}. Example: ${mod(17, 5)}";

    @Override
    public String getName() {
        return "mod()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                try {
                    return (int)Double.parseDouble(sources[0].toString()) % (int)Double.parseDouble(sources[1].toString());
                }
                catch (NumberFormatException nfe) {
                    this.logException(caller, nfe, sources);
                    return nfe.getMessage();
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MODULO;
    }

    @Override
    public String shortDescription() {
        return "Returns the remainder of the division";
    }
}

