/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class NumberFormatFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_NUMBER_FORMAT = "Usage: ${number_format(value, ISO639LangCode, pattern)}. Example: ${number_format(12345.6789, 'en', '#,##0.00')}";
    public static final String ERROR_MESSAGE_NUMBER_FORMAT_JS = "Usage: ${{Structr.numberFormat(value, ISO639LangCode, pattern)}}. Example: ${{Structr.numberFormat(12345.6789, 'en', '#,##0.00')}}";

    @Override
    public String getName() {
        return "number_format()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources.length != 3 || sources[1] == null || sources[2] == null) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        if (this.arrayHasLengthAndAllElementsNotNull(sources, 3)) {
            try {
                Double val = Double.parseDouble(sources[0].toString());
                String langCode = sources[1].toString();
                String pattern = sources[2].toString();
                return new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.forLanguageTag(langCode))).format(val);
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            }
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_NUMBER_FORMAT_JS : ERROR_MESSAGE_NUMBER_FORMAT;
    }

    @Override
    public String shortDescription() {
        return "Formats the given value using the given number format string";
    }
}

