/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class OrFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_OR = "Usage: ${or(bool1, bool2)}. Example: ${or(\"true\", \"true\")}";

    @Override
    public String getName() {
        return "or()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        boolean result = false;
        if (sources != null) {
            if (sources.length < 2) {
                return this.usage(ctx.isJavaScriptContext());
            }
            for (Object i : sources) {
                if (i != null) {
                    try {
                        result |= "true".equals(i.toString()) || Boolean.TRUE.equals(i);
                        continue;
                    }
                    catch (Throwable t) {
                        return t.getMessage();
                    }
                }
                result |= false;
            }
        }
        return result;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_OR;
    }

    @Override
    public String shortDescription() {
        return "Returns the disjunction of the given arguments";
    }
}

