/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ParseNumberFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_PARSE_NUMBER = "Usage: ${parse_number(value, locale)}. Example: ${parse_number('12345.6789', 'en')}";
    public static final String ERROR_MESSAGE_PARSE_NUMBER_JS = "Usage: ${{Structr.parseNumber(value, pattern)}}. Example: ${{Structr.parseNumber('12345.6789', 'en')}}";

    @Override
    public String getName() {
        return "parse_number()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources.length == 2 && sources[1] == null || sources.length > 2) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        try {
            String numberString = sources[0].toString().replaceAll("[^\\d.,]", "");
            if (StringUtils.isBlank((CharSequence)numberString)) {
                return "";
            }
            Locale locale = ctx.getLocale();
            try {
                String localeString;
                if (sources.length == 2 && StringUtils.isNotBlank((CharSequence)(localeString = sources[1].toString()))) {
                    locale = Locale.forLanguageTag(localeString);
                }
                return NumberFormat.getInstance(locale).parse(numberString);
            }
            catch (ParseException ex) {
                this.logException(ex, "{}: Could not parse string \"{}\" to number. Parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_PARSE_NUMBER_JS : ERROR_MESSAGE_PARSE_NUMBER;
    }

    @Override
    public String shortDescription() {
        return "Parses the given string using the given (optional) locale and format string";
    }
}

