/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class RInterpreterFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_R = "Usage: ${r(<R code>)}";
    public static final String ERROR_MESSAGE_R_JS = "Usage: ${{Structr.r(<R code>)}}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
            String script = sources[0].toString();
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("Renjin");
            if (engine == null) {
                throw new RuntimeException("Renjin Script Engine not found on the classpath.");
            }
            try {
                return engine.eval(script);
            }
            catch (ScriptException e) {
                logger.error("Error while executing R script: {}", new Object[]{script, e});
            }
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_R_JS : ERROR_MESSAGE_R;
    }

    @Override
    public String shortDescription() {
        return "";
    }

    @Override
    public String getName() {
        return "r()";
    }
}

